/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fo;

public class NumberedListItem {
    private static final String[] DECIMALS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26"};
    private static final String[] LOWER_ALPHAS = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private static final String[] UPPER_ALPHAS = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final String[] LOWER_ROMANS = new String[]{"i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix", "x", "xi", "xii", "xiii", "xiv", "xv", "xvi", "xvii", "xviii", "xix", "xx", "xxi", "xxii", "xxiii", "xxiv", "xxv", "xxvi"};
    private static final String[] UPPER_ROMANS = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "XVI", "XVII", "XVIII", "XIX", "XX", "XXI", "XXII", "XXIII", "XXIV", "XXV", "XXVI"};
    private int count;
    private final int format;

    public NumberedListItem(int itemFormat) {
        if (!this.isValidItemFormat(itemFormat)) {
            throw new IllegalArgumentException("Unknown item format!");
        }
        this.format = itemFormat;
        this.count = 0;
    }

    public int count() {
        return this.count;
    }

    public int format() {
        return this.format;
    }

    public void next() {
        ++this.count;
    }

    public String getListItemSymbol() {
        String symbol;
        int j = this.count() - 1;
        if (j < 0) {
            j = 0;
        } else if (j > DECIMALS.length - 1) {
            j = DECIMALS.length - 1;
        }
        switch (this.format()) {
            case 2: {
                symbol = UPPER_ALPHAS[j];
                break;
            }
            case 1: {
                symbol = LOWER_ALPHAS[j];
                break;
            }
            case 4: {
                symbol = UPPER_ROMANS[j];
                break;
            }
            case 3: {
                symbol = LOWER_ROMANS[j];
                break;
            }
            default: {
                symbol = DECIMALS[j];
            }
        }
        return symbol;
    }

    private boolean isValidItemFormat(int itemFormat) {
        return itemFormat == 2 || itemFormat == 1 || itemFormat == 4 || itemFormat == 3 || itemFormat == 0;
    }
}

