/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xdoc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.manager.MacroNotFoundException;
import org.apache.maven.doxia.module.xdoc.XdocMarkup;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.XhtmlBaseParser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class XdocParser
extends XhtmlBaseParser
implements XdocMarkup {
    private String sourceContent;
    private boolean isEmptyElement;
    private String macroName;
    private Map macroParameters = new HashMap();
    private boolean inHead;
    private boolean hasTitle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader source, Sink sink) throws ParseException {
        this.sourceContent = null;
        this.init();
        try {
            StringWriter contentWriter = new StringWriter();
            IOUtil.copy(source, (Writer)contentWriter);
            this.sourceContent = contentWriter.toString();
        }
        catch (IOException ex) {
            throw new ParseException("Error reading the input source: " + ex.getMessage(), ex);
        }
        finally {
            IOUtil.close(source);
        }
        StringReader tmp = new StringReader(this.sourceContent);
        try {
            super.parse(tmp, sink);
        }
        finally {
            this.sourceContent = null;
            this.setSecondParsing(false);
            this.init();
        }
    }

    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        this.isEmptyElement = parser.isEmptyElementTag();
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        if (parser.getName().equals(DOCUMENT_TAG.toString())) {
            return;
        }
        if (parser.getName().equals(HEAD.toString())) {
            if (!this.inHead) {
                this.inHead = true;
                sink.head(attribs);
            }
        } else if (parser.getName().equals(TITLE.toString())) {
            if (this.hasTitle) {
                this.getLog().warn("<title> was already defined in <properties>, ignored <title> in <head>.");
                try {
                    parser.nextText();
                }
                catch (IOException ex) {
                    throw new XmlPullParserException("Failed to parse text", parser, ex);
                }
            } else {
                sink.title(attribs);
            }
        } else if (parser.getName().equals(AUTHOR_TAG.toString())) {
            sink.author(attribs);
        } else if (parser.getName().equals(DATE_TAG.toString())) {
            sink.date(attribs);
        } else if (parser.getName().equals(META.toString())) {
            this.handleMetaStart(parser, sink, attribs);
        } else if (parser.getName().equals(BODY.toString())) {
            if (this.inHead) {
                sink.head_();
                this.inHead = false;
            }
            sink.body(attribs);
        } else if (parser.getName().equals(SECTION_TAG.toString())) {
            this.handleSectionStart(1, sink, attribs, parser);
        } else if (parser.getName().equals(SUBSECTION_TAG.toString())) {
            this.handleSectionStart(2, sink, attribs, parser);
        } else if (parser.getName().equals(SOURCE_TAG.toString())) {
            this.verbatim();
            attribs.addAttributes(SinkEventAttributeSet.BOXED);
            sink.verbatim(attribs);
        } else if (parser.getName().equals(PROPERTIES_TAG.toString())) {
            if (!this.inHead) {
                this.inHead = true;
                sink.head(attribs);
            }
        } else if (parser.getName().equals(MACRO_TAG.toString())) {
            this.handleMacroStart(parser);
        } else if (parser.getName().equals(PARAM.toString())) {
            this.handleParamStart(parser, sink);
        } else if (!this.baseStartTag(parser, sink)) {
            if (this.isEmptyElement) {
                this.handleUnknown(parser, sink, 1);
            } else {
                this.handleUnknown(parser, sink, 2);
            }
            if (this.getLog().isDebugEnabled()) {
                String position = "[" + parser.getLineNumber() + ":" + parser.getColumnNumber() + "]";
                String tag = "<" + parser.getName() + ">";
                this.getLog().debug("Unrecognized xdoc tag: " + tag + " at " + position);
            }
        }
    }

    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (parser.getName().equals(DOCUMENT_TAG.toString())) {
            return;
        }
        if (!parser.getName().equals(HEAD.toString())) {
            if (parser.getName().equals(BODY.toString())) {
                this.consecutiveSections(0, sink);
                sink.body_();
            } else if (parser.getName().equals(TITLE.toString())) {
                if (!this.hasTitle) {
                    sink.title_();
                    this.hasTitle = true;
                }
            } else if (parser.getName().equals(AUTHOR_TAG.toString())) {
                sink.author_();
            } else if (parser.getName().equals(DATE_TAG.toString())) {
                sink.date_();
            } else if (parser.getName().equals(SOURCE_TAG.toString())) {
                this.verbatim_();
                sink.verbatim_();
            } else if (!parser.getName().equals(PROPERTIES_TAG.toString())) {
                if (parser.getName().equals(MACRO_TAG.toString())) {
                    this.handleMacroEnd(sink);
                } else if (parser.getName().equals(PARAM.toString())) {
                    if (!StringUtils.isNotEmpty(this.macroName)) {
                        this.handleUnknown(parser, sink, 3);
                    }
                } else if (parser.getName().equals(SECTION_TAG.toString())) {
                    this.consecutiveSections(0, sink);
                    sink.section1_();
                } else if (parser.getName().equals(SUBSECTION_TAG.toString())) {
                    this.consecutiveSections(1, sink);
                } else if (!this.baseEndTag(parser, sink) && !this.isEmptyElement) {
                    this.handleUnknown(parser, sink, 3);
                }
            }
        }
        this.isEmptyElement = false;
    }

    protected void consecutiveSections(int newLevel, Sink sink) {
        this.closeOpenSections(newLevel, sink);
        this.openMissingSections(newLevel, sink);
        this.setSectionLevel(newLevel);
    }

    protected void init() {
        super.init();
        this.isEmptyElement = false;
        this.macroName = null;
        this.macroParameters = null;
        this.inHead = false;
        this.hasTitle = false;
    }

    private void closeOpenSections(int newLevel, Sink sink) {
        while (this.getSectionLevel() >= newLevel) {
            if (this.getSectionLevel() == 5) {
                sink.section5_();
            } else if (this.getSectionLevel() == 4) {
                sink.section4_();
            } else if (this.getSectionLevel() == 3) {
                sink.section3_();
            } else if (this.getSectionLevel() == 2) {
                sink.section2_();
            }
            this.setSectionLevel(this.getSectionLevel() - 1);
        }
    }

    private void handleMacroEnd(Sink sink) throws MacroExecutionException {
        if (!this.isSecondParsing() && StringUtils.isNotEmpty(this.macroName)) {
            this.macroParameters.put("sourceContent", this.sourceContent);
            XdocParser xdocParser = new XdocParser();
            xdocParser.setSecondParsing(true);
            this.macroParameters.put("parser", xdocParser);
            MacroRequest request = new MacroRequest(this.macroParameters, this.getBasedir());
            try {
                this.executeMacro(this.macroName, request, sink);
            }
            catch (MacroNotFoundException me) {
                throw new MacroExecutionException("Macro not found: " + this.macroName, me);
            }
        }
        this.macroName = null;
        this.macroParameters = null;
    }

    private void handleMacroStart(XmlPullParser parser) throws MacroExecutionException {
        if (!this.isSecondParsing()) {
            this.macroName = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
            if (this.macroParameters == null) {
                this.macroParameters = new HashMap();
            }
            if (StringUtils.isEmpty(this.macroName)) {
                throw new MacroExecutionException("The '" + HTML.Attribute.NAME.toString() + "' attribute for the '" + MACRO_TAG.toString() + "' tag is required.");
            }
        }
    }

    private void handleMetaStart(XmlPullParser parser, Sink sink, SinkEventAttributeSet attribs) {
        String name = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
        String content = parser.getAttributeValue(null, HTML.Attribute.CONTENT.toString());
        if ("author".equals(name)) {
            sink.author(null);
            sink.text(content);
            sink.author_();
        } else if ("date".equals(name)) {
            sink.date(null);
            sink.text(content);
            sink.date_();
        } else {
            sink.unknown("meta", new Object[]{new Integer(1)}, attribs);
        }
    }

    private void handleParamStart(XmlPullParser parser, Sink sink) throws MacroExecutionException {
        if (!this.isSecondParsing()) {
            if (StringUtils.isNotEmpty(this.macroName)) {
                String paramName = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
                String paramValue = parser.getAttributeValue(null, HTML.Attribute.VALUE.toString());
                if (StringUtils.isEmpty(paramName) || StringUtils.isEmpty(paramValue)) {
                    throw new MacroExecutionException("'" + HTML.Attribute.NAME.toString() + "' and '" + HTML.Attribute.VALUE.toString() + "' attributes for the '" + PARAM.toString() + "' tag are required inside the '" + MACRO_TAG.toString() + "' tag.");
                }
                this.macroParameters.put(paramName, paramValue);
            } else {
                this.handleUnknown(parser, sink, 2);
            }
        }
    }

    private void handleSectionStart(int level, Sink sink, SinkEventAttributeSet attribs, XmlPullParser parser) {
        this.consecutiveSections(level, sink);
        Object id = attribs.getAttribute(HTML.Attribute.ID.toString());
        if (id != null) {
            sink.anchor(id.toString());
            sink.anchor_();
        }
        sink.section(level, attribs);
        sink.sectionTitle(level, attribs);
        sink.text(HtmlTools.unescapeHTML(parser.getAttributeValue(null, HTML.Attribute.NAME.toString())));
        sink.sectionTitle_(level);
    }

    private void openMissingSections(int newLevel, Sink sink) {
        while (this.getSectionLevel() < newLevel - 1) {
            this.setSectionLevel(this.getSectionLevel() + 1);
            if (this.getSectionLevel() == 5) {
                sink.section5();
                continue;
            }
            if (this.getSectionLevel() == 4) {
                sink.section4();
                continue;
            }
            if (this.getSectionLevel() == 3) {
                sink.section3();
                continue;
            }
            if (this.getSectionLevel() != 2) continue;
            sink.section2();
        }
    }
}

