/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.wrapper;

import com.ibm.icu.text.CharsetDetector;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.apache.maven.doxia.wrapper.AbstractWrapper;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

abstract class AbstractFileWrapper
extends AbstractWrapper {
    public static final String AUTO_ENCODING = "auto";
    private File file;
    private String encoding;

    AbstractFileWrapper(String absolutePath, String format, String encoding, String[] supportedFormat) throws UnsupportedEncodingException {
        super(format, supportedFormat);
        if (StringUtils.isEmpty(absolutePath)) {
            throw new IllegalArgumentException("absolutePath is required");
        }
        File filetoset = new File(absolutePath);
        if (!filetoset.isAbsolute()) {
            filetoset = new File(new File("").getAbsolutePath(), absolutePath);
        }
        this.file = filetoset;
        if (StringUtils.isNotEmpty(encoding) && !encoding.equalsIgnoreCase(encoding) && !AbstractFileWrapper.validateEncoding(encoding)) {
            StringBuffer msg = new StringBuffer();
            msg.append("The encoding '" + encoding + "' is not a valid one. The supported charsets are: ");
            msg.append(StringUtils.join(CharsetDetector.getAllDetectableCharsets(), ", "));
            throw new UnsupportedEncodingException(msg.toString());
        }
        this.encoding = StringUtils.isNotEmpty(encoding) ? encoding : AUTO_ENCODING;
    }

    public File getFile() {
        return this.file;
    }

    void setFile(File file) {
        this.file = file;
    }

    public String getEncoding() {
        return this.encoding;
    }

    void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean validateEncoding(String charsetName) {
        if (StringUtils.isEmpty(charsetName)) {
            return false;
        }
        ByteArrayOutputStream ost = new ByteArrayOutputStream();
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)ost, charsetName);
        }
        catch (UnsupportedEncodingException exc) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtil.close(osw);
                throw throwable;
            }
            IOUtil.close(osw);
            return bl;
        }
        IOUtil.close(osw);
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractFileWrapper)) {
            return false;
        }
        AbstractFileWrapper that = (AbstractFileWrapper)other;
        boolean result = true;
        boolean bl = result = result && super.equals(other);
        result = result && (this.getFile() == null ? that.getFile() == null : this.getFile().equals(that.getFile()));
        return result;
    }

    public int hashCode() {
        int result = super.hashCode();
        int hash = 37;
        return 37 * result + (this.getFile() != null ? this.getFile().hashCode() : 0);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString() + "\n");
        buf.append("file= '");
        buf.append(this.getFile() + "'");
        return buf.toString();
    }
}

