/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.util;

import org.apache.maven.doxia.UnsupportedFormatException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.SinkFactory;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class ConverterUtil {
    public static Parser getParser(PlexusContainer plexus, String format, String[] supportedFormats) throws ComponentLookupException, UnsupportedFormatException {
        if (plexus == null) {
            throw new IllegalArgumentException("plexus is required");
        }
        if (format == null) {
            throw new IllegalArgumentException("format is required");
        }
        if (supportedFormats == null) {
            throw new IllegalArgumentException("supportedFormats is required");
        }
        Parser parser = null;
        for (int i = 0; i < supportedFormats.length; ++i) {
            if (!format.equalsIgnoreCase(supportedFormats[i])) continue;
            parser = (Parser)plexus.lookup(Parser.ROLE, format);
        }
        if (parser == null) {
            throw new UnsupportedFormatException(format, supportedFormats);
        }
        return parser;
    }

    public static SinkFactory getSinkFactory(PlexusContainer plexus, String format, String[] supportedFormats) throws ComponentLookupException, UnsupportedFormatException {
        if (plexus == null) {
            throw new IllegalArgumentException("plexus is required");
        }
        if (format == null) {
            throw new IllegalArgumentException("format is required");
        }
        if (supportedFormats == null) {
            throw new IllegalArgumentException("supportedFormats is required");
        }
        SinkFactory factory = null;
        for (int i = 0; i < supportedFormats.length; ++i) {
            if (!format.equalsIgnoreCase(supportedFormats[i])) continue;
            factory = (SinkFactory)plexus.lookup(SinkFactory.ROLE, format);
        }
        if (factory == null) {
            throw new UnsupportedFormatException(format, supportedFormats);
        }
        return factory;
    }
}

