/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.linkcheck;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.doxia.linkcheck.HttpBean;
import org.apache.maven.doxia.linkcheck.LinkCheck;
import org.apache.maven.doxia.linkcheck.LinkCheckException;
import org.apache.maven.doxia.linkcheck.LinkMatcher;
import org.apache.maven.doxia.linkcheck.model.LinkcheckFile;
import org.apache.maven.doxia.linkcheck.model.LinkcheckFileResult;
import org.apache.maven.doxia.linkcheck.model.LinkcheckModel;
import org.apache.maven.doxia.linkcheck.model.io.xpp3.LinkcheckModelXpp3Writer;
import org.apache.maven.doxia.linkcheck.validation.FileLinkValidator;
import org.apache.maven.doxia.linkcheck.validation.HTTPLinkValidationResult;
import org.apache.maven.doxia.linkcheck.validation.LinkValidationItem;
import org.apache.maven.doxia.linkcheck.validation.LinkValidationResult;
import org.apache.maven.doxia.linkcheck.validation.LinkValidatorManager;
import org.apache.maven.doxia.linkcheck.validation.MailtoLinkValidator;
import org.apache.maven.doxia.linkcheck.validation.OfflineHTTPLinkValidator;
import org.apache.maven.doxia.linkcheck.validation.OnlineHTTPLinkValidator;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public final class DefaultLinkCheck
implements LinkCheck {
    private static final Log LOG = LogFactory.getLog((Class)DefaultLinkCheck.class);
    private static final FilenameFilter CUSTOM_FF = new CustomFilenameFilter();
    private static final long MEG = 0x100000L;
    private File basedir;
    private File linkCheckCache;
    private String[] excludedLinks = null;
    private String[] excludedPages = null;
    private int[] excludedHttpStatusErrors = null;
    private int[] excludedHttpStatusWarnings = null;
    private boolean online;
    private HttpBean http;
    private LinkValidatorManager lvm = null;
    private File reportOutput;
    private String reportOutputEncoding = "UTF-8";
    private String baseURL;
    private String encoding = "UTF-8";

    public void setBasedir(File base) {
        this.basedir = base;
    }

    public void setBaseURL(String url) {
        this.baseURL = url;
    }

    public void setExcludedHttpStatusErrors(int[] excl) {
        this.excludedHttpStatusErrors = excl;
    }

    public void setExcludedHttpStatusWarnings(int[] excl) {
        this.excludedHttpStatusWarnings = excl;
    }

    public void setExcludedLinks(String[] excl) {
        this.excludedLinks = excl;
    }

    public void setExcludedPages(String[] excl) {
        this.excludedPages = excl;
    }

    public void setHttp(HttpBean http) {
        this.http = http;
    }

    public void setLinkCheckCache(File cacheFile) {
        this.linkCheckCache = cacheFile;
    }

    public void setOnline(boolean onLine) {
        this.online = onLine;
    }

    public void setReportOutput(File file) {
        this.reportOutput = file;
    }

    public void setReportOutputEncoding(String enc) {
        this.reportOutputEncoding = enc;
    }

    public LinkcheckModel execute() throws LinkCheckException {
        if (this.basedir == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"No base directory specified!");
            }
            throw new NullPointerException("The basedir can't be null!");
        }
        if (this.reportOutput == null && LOG.isWarnEnabled()) {
            LOG.warn((Object)"No output file specified! Results will not be written!");
        }
        LinkcheckModel model = new LinkcheckModel();
        model.setModelEncoding(this.reportOutputEncoding);
        model.setFiles(new LinkedList());
        this.displayMemoryConsumption();
        LinkValidatorManager validator = this.getLinkValidatorManager();
        try {
            validator.loadCache(this.linkCheckCache);
        }
        catch (IOException e) {
            throw new LinkCheckException("Could not load cache: " + e.getMessage(), e);
        }
        this.displayMemoryConsumption();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Begin to check links in files...");
        }
        this.findAndCheckFiles(this.basedir, model);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Links checked.");
        }
        this.displayMemoryConsumption();
        try {
            this.createDocument(model);
        }
        catch (IOException e) {
            throw new LinkCheckException("Could not write the linkcheck document: " + e.getMessage(), e);
        }
        try {
            validator.saveCache(this.linkCheckCache);
        }
        catch (IOException e) {
            throw new LinkCheckException("Could not save cache: " + e.getMessage(), e);
        }
        this.displayMemoryConsumption();
        return model;
    }

    public void setEncoding(String encoding) {
        if (StringUtils.isEmpty((String)encoding)) {
            throw new IllegalArgumentException("encoding is required");
        }
        try {
            Charset.forName(encoding);
        }
        catch (UnsupportedCharsetException e) {
            throw new IllegalArgumentException("encoding '" + encoding + "' is unsupported");
        }
        this.encoding = encoding;
    }

    private boolean isOnline() {
        return this.online;
    }

    private File getBasedir() {
        return this.basedir;
    }

    private String[] getExcludedLinks() {
        return this.excludedLinks;
    }

    private String[] getExcludedPages() {
        return this.excludedPages;
    }

    private int[] getExcludedHttpStatusErrors() {
        return this.excludedHttpStatusErrors;
    }

    private int[] getExcludedHttpStatusWarnings() {
        return this.excludedHttpStatusWarnings;
    }

    private void setLinkValidatorManager(LinkValidatorManager validator) {
        this.lvm = validator;
    }

    private LinkValidatorManager getLinkValidatorManager() {
        if (this.lvm == null) {
            this.initDefaultLinkValidatorManager();
        }
        return this.lvm;
    }

    private void initDefaultLinkValidatorManager() {
        this.lvm = new LinkValidatorManager();
        if (this.getExcludedLinks() != null) {
            this.lvm.setExcludedLinks(this.getExcludedLinks());
        }
        this.lvm.addLinkValidator(new FileLinkValidator(this.encoding));
        if (this.isOnline()) {
            OnlineHTTPLinkValidator olv = new OnlineHTTPLinkValidator(this.http);
            if (this.baseURL != null) {
                olv.setBaseURL(this.baseURL);
            }
            this.lvm.addLinkValidator(olv);
        } else {
            this.lvm.addLinkValidator(new OfflineHTTPLinkValidator());
        }
        this.lvm.addLinkValidator(new MailtoLinkValidator());
    }

    private void findAndCheckFiles(File base, LinkcheckModel model) {
        File[] f = base.listFiles(CUSTOM_FF);
        if (f != null) {
            File file;
            for (int i = 0; i < f.length; ++i) {
                String fileRelativePath;
                file = f[i];
                if (file.isDirectory()) {
                    this.findAndCheckFiles(file, model);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(" File - " + file));
                }
                if (this.getExcludedPages() != null) {
                    String diff = StringUtils.difference((String)this.getBasedir().getAbsolutePath(), (String)file.getAbsolutePath());
                    if (diff.startsWith(File.separator)) {
                        diff = diff.substring(1);
                    }
                    if (Arrays.binarySearch(this.getExcludedPages(), diff) >= 0) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)(" Ignored analysis of " + file));
                        continue;
                    }
                }
                if ((fileRelativePath = file.getAbsolutePath()).startsWith(this.basedir.getAbsolutePath())) {
                    fileRelativePath = fileRelativePath.substring(this.basedir.getAbsolutePath().length() + 1);
                }
                fileRelativePath = fileRelativePath.replace('\\', '/');
                LinkcheckFile linkcheckFile = new LinkcheckFile();
                linkcheckFile.setAbsolutePath(file.getAbsolutePath());
                linkcheckFile.setRelativePath(fileRelativePath);
                this.check(linkcheckFile);
                model.addFile(linkcheckFile);
                if (model.getFiles().size() % 100 != 0 || !LOG.isInfoEnabled()) continue;
                LOG.info((Object)("Found " + model.getFiles().size() + " files so far."));
            }
            file = null;
        }
        f = null;
    }

    private void check(LinkcheckFile linkcheckFile) {
        LinkValidationResult result;
        LinkValidationItem lvi;
        LinkcheckFileResult lcr;
        String href;
        Set hrefs;
        linkcheckFile.setSuccessful(0);
        linkcheckFile.setUnsuccessful(0);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Validating " + linkcheckFile.getRelativePath()));
        }
        try {
            hrefs = LinkMatcher.match(new File(linkcheckFile.getAbsolutePath()), this.encoding);
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Received: [" + t + "] in page [" + linkcheckFile.getRelativePath() + "]"), t);
            } else {
                LOG.error((Object)("Received: [" + t + "] in page [" + linkcheckFile.getRelativePath() + "]"));
            }
            LinkcheckFileResult lcr2 = new LinkcheckFileResult();
            lcr2.setStatus("PARSE FAILURE");
            lcr2.setTarget("N/A");
            linkcheckFile.addResult(lcr2);
            return;
        }
        Iterator iter = hrefs.iterator();
        block7: while (iter.hasNext()) {
            href = (String)iter.next();
            lcr = new LinkcheckFileResult();
            lvi = new LinkValidationItem(new File(linkcheckFile.getAbsolutePath()), href);
            result = this.lvm.validateLink(lvi);
            lcr.setTarget(href);
            lcr.setErrorMessage(result.getErrorMessage());
            switch (result.getStatus()) {
                case 3: {
                    linkcheckFile.setSuccessful(linkcheckFile.getSuccessful() + 1);
                    lcr.setStatus("valid");
                    linkcheckFile.addResult(lcr);
                    continue block7;
                }
                case 1: {
                    HTTPLinkValidationResult httpResult;
                    boolean ignoredError = false;
                    if (result instanceof HTTPLinkValidationResult && (httpResult = (HTTPLinkValidationResult)result).getHttpStatusCode() > 0 && this.getExcludedHttpStatusErrors() != null && StringUtils.indexOfAny((String)String.valueOf(httpResult.getHttpStatusCode()), (String[])DefaultLinkCheck.toStringArray(this.getExcludedHttpStatusErrors())) >= 0) {
                        ignoredError = true;
                    }
                    if (ignoredError) {
                        linkcheckFile.setSuccessful(linkcheckFile.getSuccessful() + 1);
                    } else {
                        linkcheckFile.setUnsuccessful(linkcheckFile.getUnsuccessful() + 1);
                    }
                    lcr.setStatus(ignoredError ? "valid" : "error");
                    linkcheckFile.addResult(lcr);
                    continue block7;
                }
                case 2: {
                    HTTPLinkValidationResult httpResult;
                    boolean ignoredWarning = false;
                    if (result instanceof HTTPLinkValidationResult && (httpResult = (HTTPLinkValidationResult)result).getHttpStatusCode() > 0 && this.getExcludedHttpStatusWarnings() != null && StringUtils.indexOfAny((String)String.valueOf(httpResult.getHttpStatusCode()), (String[])DefaultLinkCheck.toStringArray(this.getExcludedHttpStatusWarnings())) >= 0) {
                        ignoredWarning = true;
                    }
                    if (ignoredWarning) {
                        linkcheckFile.setSuccessful(linkcheckFile.getSuccessful() + 1);
                    } else {
                        linkcheckFile.setUnsuccessful(linkcheckFile.getUnsuccessful() + 1);
                    }
                    lcr.setStatus(ignoredWarning ? "valid" : "warning");
                    linkcheckFile.addResult(lcr);
                    continue block7;
                }
            }
            linkcheckFile.setUnsuccessful(linkcheckFile.getUnsuccessful() + 1);
            lcr.setStatus("unknown");
            linkcheckFile.addResult(lcr);
        }
        href = null;
        lcr = null;
        lvi = null;
        result = null;
    }

    private void displayMemoryConsumption() {
        if (LOG.isDebugEnabled()) {
            Runtime r = Runtime.getRuntime();
            LOG.debug((Object)("Memory: " + (r.totalMemory() - r.freeMemory()) / 0x100000L + "M/" + r.totalMemory() / 0x100000L + "M"));
        }
    }

    private void createDocument(LinkcheckModel model) throws IOException {
        if (this.reportOutput == null) {
            return;
        }
        File dir = this.reportOutput.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        XmlStreamWriter writer = null;
        LinkcheckModelXpp3Writer xpp3Writer = new LinkcheckModelXpp3Writer();
        try {
            writer = WriterFactory.newXmlWriter((File)this.reportOutput);
            xpp3Writer.write((Writer)writer, model);
        }
        catch (IllegalStateException e) {
            IOException ioe = new IOException(e.getMessage() + " Maybe try to specify an other encoding instead of '" + this.encoding + "'.");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            IOUtil.close((Writer)writer);
        }
        dir = null;
    }

    private static String[] toStringArray(int[] array) {
        if (array == null) {
            throw new IllegalArgumentException("array could not be null");
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = String.valueOf(array[i]);
        }
        return result;
    }

    static class CustomFilenameFilter
    implements FilenameFilter {
        CustomFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            File n = new File(dir, name);
            if (n.isDirectory()) {
                return true;
            }
            return name.toLowerCase(Locale.ENGLISH).endsWith(".html") || name.toLowerCase(Locale.ENGLISH).endsWith(".htm");
        }
    }
}

