/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.linkcheck.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.doxia.linkcheck.model.LinkcheckFileResult;

public class LinkcheckFile
implements Serializable {
    private String absolutePath;
    private String relativePath;
    private int successful = -1;
    private int unsuccessful = -1;
    private List results;

    public void addResult(LinkcheckFileResult linkcheckFileResult) {
        this.getResults().add(linkcheckFileResult);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LinkcheckFile)) {
            return false;
        }
        LinkcheckFile that = (LinkcheckFile)other;
        boolean result = true;
        boolean bl = result && (this.getAbsolutePath() == null ? that.getAbsolutePath() == null : this.getAbsolutePath().equals(that.getAbsolutePath())) ? true : (result = false);
        result = result && (this.getRelativePath() == null ? that.getRelativePath() == null : this.getRelativePath().equals(that.getRelativePath()));
        result = result && this.successful == that.successful;
        boolean bl2 = result = result && this.unsuccessful == that.unsuccessful;
        result = result && (this.getResults() == null ? that.getResults() == null : ((Object)this.getResults()).equals(that.getResults()));
        return result;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public List getResults() {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        return this.results;
    }

    public int getSuccessful() {
        return this.successful;
    }

    public int getUnsuccessful() {
        return this.unsuccessful;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.absolutePath != null ? this.absolutePath.hashCode() : 0);
        result = 37 * result + (this.relativePath != null ? this.relativePath.hashCode() : 0);
        result = 37 * result + this.successful;
        result = 37 * result + this.unsuccessful;
        result = 37 * result + (this.results != null ? ((Object)this.results).hashCode() : 0);
        return result;
    }

    public void removeResult(LinkcheckFileResult linkcheckFileResult) {
        this.getResults().remove(linkcheckFileResult);
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public void setResults(List results) {
        this.results = results;
    }

    public void setSuccessful(int successful) {
        this.successful = successful;
    }

    public void setUnsuccessful(int unsuccessful) {
        this.unsuccessful = unsuccessful;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("absolutePath = '");
        buf.append(this.getAbsolutePath());
        buf.append("'");
        buf.append("\n");
        buf.append("relativePath = '");
        buf.append(this.getRelativePath());
        buf.append("'");
        buf.append("\n");
        buf.append("successful = '");
        buf.append(this.getSuccessful());
        buf.append("'");
        buf.append("\n");
        buf.append("unsuccessful = '");
        buf.append(this.getUnsuccessful());
        buf.append("'");
        buf.append("\n");
        buf.append("results = '");
        buf.append(this.getResults());
        buf.append("'");
        return buf.toString();
    }

    public int getNumberOfLinks(int level) {
        if (this.results == null) {
            return -1;
        }
        if (level != 1 && level != 2 && level != 3 && level != 4) {
            throw new UnsupportedOperationException("This level [" + level + "] is unsupported.");
        }
        int number = 0;
        Iterator it = this.results.iterator();
        while (it.hasNext()) {
            LinkcheckFileResult linkcheckFileResult = (LinkcheckFileResult)it.next();
            if (linkcheckFileResult.getStatusLevel() != level) continue;
            ++number;
        }
        return number;
    }

    public int getNumberOfLinks() {
        if (this.results == null) {
            return -1;
        }
        return this.results.size();
    }
}

