/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.linkcheck.model.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.doxia.linkcheck.model.LinkcheckFile;
import org.apache.maven.doxia.linkcheck.model.LinkcheckFileResult;
import org.apache.maven.doxia.linkcheck.model.LinkcheckModel;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class LinkcheckModelXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, LinkcheckModel linkcheckModel) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(linkcheckModel.getModelEncoding(), null);
        this.writeLinkcheckModel(linkcheckModel, "linkcheckModel", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeLinkcheckFile(LinkcheckFile linkcheckFile, String tagName, XmlSerializer serializer) throws IOException {
        if (linkcheckFile != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (linkcheckFile.getAbsolutePath() != null) {
                serializer.startTag(NAMESPACE, "absolutePath").text(linkcheckFile.getAbsolutePath()).endTag(NAMESPACE, "absolutePath");
            }
            if (linkcheckFile.getRelativePath() != null) {
                serializer.startTag(NAMESPACE, "relativePath").text(linkcheckFile.getRelativePath()).endTag(NAMESPACE, "relativePath");
            }
            if (linkcheckFile.getSuccessful() != -1) {
                serializer.startTag(NAMESPACE, "successful").text(String.valueOf(linkcheckFile.getSuccessful())).endTag(NAMESPACE, "successful");
            }
            if (linkcheckFile.getUnsuccessful() != -1) {
                serializer.startTag(NAMESPACE, "unsuccessful").text(String.valueOf(linkcheckFile.getUnsuccessful())).endTag(NAMESPACE, "unsuccessful");
            }
            if (linkcheckFile.getResults() != null && linkcheckFile.getResults().size() > 0) {
                serializer.startTag(NAMESPACE, "results");
                Iterator iter = linkcheckFile.getResults().iterator();
                while (iter.hasNext()) {
                    LinkcheckFileResult o = (LinkcheckFileResult)iter.next();
                    this.writeLinkcheckFileResult(o, "result", serializer);
                }
                serializer.endTag(NAMESPACE, "results");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeLinkcheckFileResult(LinkcheckFileResult linkcheckFileResult, String tagName, XmlSerializer serializer) throws IOException {
        if (linkcheckFileResult != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (linkcheckFileResult.getTarget() != null) {
                serializer.startTag(NAMESPACE, "target").text(linkcheckFileResult.getTarget()).endTag(NAMESPACE, "target");
            }
            if (linkcheckFileResult.getStatus() != null) {
                serializer.startTag(NAMESPACE, "status").text(linkcheckFileResult.getStatus()).endTag(NAMESPACE, "status");
            }
            if (linkcheckFileResult.getErrorMessage() != null) {
                serializer.startTag(NAMESPACE, "errorMessage").text(linkcheckFileResult.getErrorMessage()).endTag(NAMESPACE, "errorMessage");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeLinkcheckModel(LinkcheckModel linkcheckModel, String tagName, XmlSerializer serializer) throws IOException {
        if (linkcheckModel != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (linkcheckModel.getFiles() != null && linkcheckModel.getFiles().size() > 0) {
                serializer.startTag(NAMESPACE, "files");
                Iterator iter = linkcheckModel.getFiles().iterator();
                while (iter.hasNext()) {
                    LinkcheckFile o = (LinkcheckFile)iter.next();
                    this.writeLinkcheckFile(o, "file", serializer);
                }
                serializer.endTag(NAMESPACE, "files");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }
}

