/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.bundlesummary;

import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.IOUtil;
import org.fusesource.mvnplugins.bundlesummary.BundleMetadata;
import org.fusesource.mvnplugins.bundlesummary.Capability;
import org.fusesource.mvnplugins.bundlesummary.PackageExport;
import org.fusesource.mvnplugins.bundlesummary.PackageImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="summary", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class SummaryMojo
extends AbstractMojo {
    @Parameter(property="session", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.build.directory}/bundle-summary.xml")
    protected File xmlReport;
    @Parameter(defaultValue="${project.build.directory}/bundle-report.xslt")
    protected File stylesheet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        TreeMap<String, BundleMetadata> bundles = new TreeMap<String, BundleMetadata>();
        TreeMap<String, Map<String, Set<BundleMetadata>>> imports = new TreeMap<String, Map<String, Set<BundleMetadata>>>();
        TreeMap<String, Map<String, Set<BundleMetadata>>> exports = new TreeMap<String, Map<String, Set<BundleMetadata>>>();
        this.getLog().info((CharSequence)("Gathering metadata of reactor's bundles (" + this.session.getProjects().size() + " artifacts)"));
        for (Object project : this.session.getProjects()) {
            File bundle;
            Artifact artifact = project.getArtifact();
            if (artifact == null || !"bundle".equals(artifact.getType())) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Verifying bundle " + artifact.getArtifactId()));
            }
            if ((bundle = artifact.getFile()) == null) {
                this.getLog().info((CharSequence)("No file for artifact " + artifact.getArtifactId()));
                continue;
            }
            JarFile jar = null;
            try {
                Object packageName2;
                jar = new JarFile(bundle);
                Manifest m = jar.getManifest();
                if (m == null || m.getMainAttributes() == null) continue;
                Attributes mainAttributes = m.getMainAttributes();
                String symbolicName = mainAttributes.getValue("Bundle-SymbolicName");
                if (symbolicName.contains(";")) {
                    symbolicName = symbolicName.substring(0, symbolicName.indexOf(59));
                }
                String version = mainAttributes.getValue("Bundle-Version");
                String exportsInfo = mainAttributes.getValue("Export-Package");
                String importsInfo = mainAttributes.getValue("Import-Package");
                String reqs = mainAttributes.getValue("Require-Capability");
                String provides = mainAttributes.getValue("Provide-Capability");
                String key = String.format("%s:%s", symbolicName, version);
                BundleMetadata metadata = new BundleMetadata();
                bundles.put(key, metadata);
                metadata.setSymbolicName(symbolicName);
                metadata.setVersion(version);
                Parameters importParameters = OSGiHeader.parseHeader((String)importsInfo);
                for (Object packageName2 : importParameters.keySet()) {
                    String packageVersion = importParameters.get((String)packageName2).getVersion();
                    if (packageVersion == null) {
                        packageVersion = "";
                    }
                    PackageImport packageImport = new PackageImport((String)packageName2, packageVersion);
                    packageImport.setOtherAttributes(importParameters.get((String)packageName2));
                    metadata.getImports().add(packageImport);
                    if (!imports.containsKey(packageName2)) {
                        imports.put((String)packageName2, new TreeMap());
                    }
                    if (!((Map)imports.get(packageName2)).containsKey(packageVersion)) {
                        ((Map)imports.get(packageName2)).put(packageVersion, new TreeSet());
                    }
                    ((Set)((Map)imports.get(packageName2)).get(packageVersion)).add(metadata);
                }
                Parameters exportParameters = OSGiHeader.parseHeader((String)exportsInfo);
                packageName2 = exportParameters.keySet().iterator();
                while (packageName2.hasNext()) {
                    String packageName3 = (String)packageName2.next();
                    String packageVersion = exportParameters.get(packageName3).getVersion();
                    if (packageVersion == null) {
                        packageVersion = "";
                    }
                    PackageExport packageExport = new PackageExport(packageName3, packageVersion);
                    packageExport.setOtherAttributes(exportParameters.get(packageName3));
                    metadata.getExports().add(packageExport);
                    if (!exports.containsKey(packageName3)) {
                        exports.put(packageName3, new TreeMap());
                    }
                    if (!((Map)exports.get(packageName3)).containsKey(packageVersion)) {
                        ((Map)exports.get(packageName3)).put(packageVersion, new TreeSet());
                    }
                    ((Set)((Map)exports.get(packageName3)).get(packageVersion)).add(metadata);
                }
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    if (entry.getName() == null || !entry.getName().endsWith(".class")) continue;
                    String packageName4 = entry.getName().substring(0, entry.getName().lastIndexOf("/"));
                    if (exports.containsKey(packageName4 = packageName4.replaceAll("/", "."))) continue;
                    metadata.getPrivatePackages().add(packageName4);
                }
                Parameters reqsParameters = OSGiHeader.parseHeader((String)reqs);
                for (String capabilityName : reqsParameters.keySet()) {
                    Capability capability = new Capability(capabilityName);
                    capability.setOtherAttributes(exportParameters.get(capabilityName));
                    metadata.getRequiredCapabilities().add(capability);
                }
                Parameters providesParameters = OSGiHeader.parseHeader((String)provides);
                for (String capabilityName : providesParameters.keySet()) {
                    Capability capability = new Capability(capabilityName);
                    capability.setOtherAttributes(exportParameters.get(capabilityName));
                    metadata.getProvidedCapabilities().add(capability);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            finally {
                if (jar == null) continue;
                try {
                    jar.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
        }
        this.getLog().info((CharSequence)"Verifying metadata of reactor's bundles");
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.xmlReport), "UTF-8");
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<?xml-stylesheet type=\"text/xsl\" href=\"bundle-report.xslt\"?>\n");
            writer.write("<bundle-report xmlns=\"http://fabric8.io/bundle-report\">\n");
            writer.write("    <bundles>\n");
            for (String id : bundles.keySet()) {
                BundleMetadata bm = (BundleMetadata)bundles.get(id);
                writer.write("        <bundle symbolic-name=\"" + bm.getSymbolicName() + "\" version=\"" + bm.getVersion() + "\">\n");
                writer.write("            <imports>\n");
                for (PackageImport pi : bm.getImports()) {
                    writer.write("                <import package=\"" + pi.getPackageName() + "\" version=\"" + pi.getVersion() + "\" />\n");
                }
                writer.write("            </imports>\n");
                writer.write("            <exports>\n");
                for (PackageExport pe : bm.getExports()) {
                    writer.write("                <export package=\"" + pe.getPackageName() + "\" version=\"" + pe.getVersion() + "\" />\n");
                }
                writer.write("            </exports>\n");
                writer.write("            <privates>\n");
                for (String p : bm.getPrivatePackages()) {
                    writer.write("                <private package=\"" + p + "\" />\n");
                }
                writer.write("            </privates>\n");
                writer.write("            <provided-capabilities>\n");
                for (Capability c : bm.getProvidedCapabilities()) {
                    writer.write("                <capability name=\"" + c.getName() + "\" />\n");
                }
                writer.write("            </provided-capabilities>\n");
                writer.write("            <required-capabilities>\n");
                for (Capability c : bm.getRequiredCapabilities()) {
                    writer.write("                <capability name=\"" + c.getName() + "\" />\n");
                }
                writer.write("            </required-capabilities>\n");
                writer.write("        </bundle>\n");
            }
            writer.write("    </bundles>\n");
            writer.write("    <imports>\n");
            this.importInformation(imports, writer);
            writer.write("    </imports>\n");
            writer.write("    <exports>\n");
            this.exportInformation(exports, writer);
            writer.write("    </exports>\n");
            if (imports.size() > 0) {
                writer.write("    <import-conflicts>\n");
                this.importInformation(imports, writer);
                writer.write("    </import-conflicts>\n");
            }
            if (exports.size() > 0) {
                writer.write("    <export-conflicts>\n");
                this.exportInformation(exports, writer);
                writer.write("    </export-conflicts>\n");
            }
            writer.write("</bundle-report>\n");
            FileOutputStream fos = new FileOutputStream(this.stylesheet);
            IOUtil.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/bundle-report.xslt"), (OutputStream)fos);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
        }
    }

    private void importInformation(Map<String, Map<String, Set<BundleMetadata>>> imports, Writer writer) throws IOException {
        Iterator<String> iterator = imports.keySet().iterator();
        while (iterator.hasNext()) {
            String packageName = iterator.next();
            Map<String, Set<BundleMetadata>> versions = imports.get(packageName);
            writer.write("        <import package=\"" + packageName + "\">\n");
            for (String version : versions.keySet()) {
                writer.write("            <version version=\"" + version + "\">\n");
                for (BundleMetadata bm : versions.get(version)) {
                    writer.write("                <by-bundle symbolic-name=\"" + bm.getSymbolicName() + "\" version=\"" + bm.getVersion() + "\" />\n");
                }
                writer.write("            </version>\n");
            }
            writer.write("        </import>\n");
            if (versions.size() != 1) continue;
            iterator.remove();
        }
    }

    private void exportInformation(Map<String, Map<String, Set<BundleMetadata>>> exports, Writer writer) throws IOException {
        Iterator<String> iterator = exports.keySet().iterator();
        while (iterator.hasNext()) {
            String packageName = iterator.next();
            Map<String, Set<BundleMetadata>> versions = exports.get(packageName);
            writer.write("        <export package=\"" + packageName + "\">\n");
            for (String version : versions.keySet()) {
                writer.write("            <version version=\"" + version + "\">\n");
                for (BundleMetadata bm : versions.get(version)) {
                    writer.write("                <by-bundle symbolic-name=\"" + bm.getSymbolicName() + "\" version=\"" + bm.getVersion() + "\" />\n");
                }
                writer.write("            </version>\n");
            }
            writer.write("        </export>\n");
            if (exports.get(packageName).size() != 1) continue;
            String singleVersion = exports.get(packageName).keySet().iterator().next();
            if (exports.get(packageName).get(singleVersion).size() != 1) continue;
            iterator.remove();
        }
    }
}

