/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.consolets;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class ConsoleTSMojo
extends AbstractMojo {
    static PrintStream originalOut = System.out;
    protected MavenProject project;
    protected boolean enabled;
    protected String format;

    public void execute() throws MojoExecutionException {
        if (this.enabled) {
            System.setOut(new PrintStream(new TimeStampOutputStream(originalOut)));
        } else {
            System.setOut(originalOut);
        }
    }

    class TimeStampOutputStream
    extends FilterOutputStream {
        SimpleDateFormat sdf;
        AtomicBoolean prefixNextWrite;

        TimeStampOutputStream(OutputStream outputStream) {
            super(outputStream);
            this.sdf = new SimpleDateFormat(ConsoleTSMojo.this.format);
            this.prefixNextWrite = new AtomicBoolean(true);
        }

        public void write(int i) throws IOException {
            if (this.prefixNextWrite.compareAndSet(true, false)) {
                super.write(("[" + this.sdf.format(new Date()) + "] ").getBytes());
            }
            super.write(i);
            if (i == 10) {
                this.prefixNextWrite.set(true);
            }
        }
    }
}

