/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.fab;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class FabMojo
extends AbstractMojo {
    public static final String FAB_MODULE_ID = "Id";
    public static final String FAB_MODULE_NAME = "Name";
    public static final String FAB_MODULE_DESCRIPTION = "Description";
    public static final String FAB_MODULE_SHA1 = "SHA1";
    protected MavenProject project;
    private MavenProjectHelper projectHelper;
    protected File target;
    protected String classifier;
    protected boolean enabled;
    protected Map<String, String> descriptor;
    static char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (!this.enabled) {
            return;
        }
        try {
            Properties p = new Properties();
            if (this.descriptor != null) {
                for (Map.Entry<String, String> entry : this.descriptor.entrySet()) {
                    if (entry.getValue() == null || entry.getValue().trim().length() == 0) continue;
                    p.put(entry.getKey(), entry.getValue().trim());
                }
            }
            if (!p.containsKey(FAB_MODULE_ID)) {
                String id = this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + ":" + this.project.getArtifact().getType() + (this.classifier == null ? "" : ":" + this.classifier);
                p.setProperty(FAB_MODULE_ID, id);
            }
            if (!p.containsKey(FAB_MODULE_NAME)) {
                p.setProperty(FAB_MODULE_NAME, this.project.getArtifactId());
            }
            if (!p.containsKey(FAB_MODULE_DESCRIPTION)) {
                p.setProperty(FAB_MODULE_DESCRIPTION, this.project.getDescription());
            }
            if (!this.project.getVersion().contains("SNAPSHOT") && this.project.getArtifact().getFile().exists()) {
                p.setProperty(FAB_MODULE_SHA1, this.checksum(FAB_MODULE_SHA1, this.project.getArtifact().getFile()));
            }
            FileOutputStream os = new FileOutputStream(this.target);
            try {
                p.store(os, null);
            }
            finally {
                os.close();
            }
            this.getLog().info((CharSequence)("Generated: " + this.target));
            this.projectHelper.attachArtifact(this.project, this.project.getArtifact().getType() + ".fmd", this.classifier, this.target);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not store the fabric module descriptor '%s'", this.target), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String checksum(String algorithm, File file) throws MojoExecutionException {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            FileInputStream is = null;
            try {
                int c;
                is = new FileInputStream(file);
                byte[] buffer = new byte[4096];
                while ((c = is.read(buffer)) >= 0) {
                    md.update(buffer, 0, c);
                }
                byte[] digest = md.digest();
                String string = FabMojo.toString(digest);
                return string;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could read file: " + file);
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new MojoExecutionException("Invalid checksum algorithm: " + algorithm, (Exception)e);
        }
    }

    static String toString(byte[] digest) {
        StringBuilder rc = new StringBuilder(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            rc.append(hexTable[digest[i] >> 4 & 0xF]);
            rc.append(hexTable[digest[i] & 0xF]);
        }
        return rc.toString();
    }
}

