/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.graph;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.fusesource.mvnplugins.graph.DependencyVisualizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectMojo
extends AbstractMojo {
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    protected ArtifactResolver artifactResolver;
    protected ArtifactFactory artifactFactory;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactCollector artifactCollector;
    protected DependencyTreeBuilder treeBuilder;
    protected File target;
    protected boolean hideOmitted;
    protected boolean hideOptional;
    protected boolean hideExternal;
    protected boolean hidePoms;
    protected String hideScopes;
    protected boolean hideTransitive;
    protected boolean hideVersion;
    protected boolean hideGroupId;
    protected String includeGroupIds;
    protected String excludeGroupIds;
    protected String includeArtifactIds;
    protected String excludeArtifactIds;
    protected boolean hideType;
    protected boolean keepDot;
    protected String label;
    protected boolean cascade;
    protected String direction;

    public void execute() throws MojoExecutionException {
        try {
            DependencyVisualizer visualizer = new DependencyVisualizer();
            visualizer.cascade = this.cascade;
            visualizer.direction = this.direction;
            visualizer.hideOptional = this.hideOptional;
            visualizer.hidePoms = this.hidePoms;
            visualizer.hideOmitted = this.hideOmitted;
            visualizer.hideExternal = this.hideExternal;
            visualizer.hideVersion = this.hideVersion;
            visualizer.hideGroupId = this.hideGroupId;
            visualizer.hideType = this.hideType;
            visualizer.keepDot = this.keepDot;
            visualizer.label = this.label;
            visualizer.hideTransitive = this.hideTransitive;
            visualizer.log = this.getLog();
            if (this.hideScopes != null) {
                for (String scope : this.hideScopes.split(",")) {
                    visualizer.hideScopes.add(scope.trim());
                }
            }
            if (this.excludeGroupIds != null) {
                for (String groupId : this.excludeGroupIds.split(",")) {
                    visualizer.excludeGroupIds.add(groupId.trim());
                }
            }
            if (this.includeGroupIds != null) {
                for (String groupId : this.includeGroupIds.split(",")) {
                    visualizer.includeGroupIds.add(groupId.trim());
                }
            }
            if (this.excludeArtifactIds != null) {
                for (String artifactId : this.excludeArtifactIds.split(",")) {
                    visualizer.excludeArtifactIds.add(artifactId.trim());
                }
            }
            if (this.includeArtifactIds != null) {
                for (String artifactId : this.includeArtifactIds.split(",")) {
                    visualizer.includeArtifactIds.add(artifactId.trim());
                }
            }
            ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
            this.collectProjects(projects);
            for (MavenProject p : projects) {
                ArtifactFilter filter = null;
                DependencyNode node = this.treeBuilder.buildDependencyTree(p, this.localRepository, this.artifactFactory, this.artifactMetadataSource, filter, this.artifactCollector);
                visualizer.add(node);
            }
            this.getTarget().getParentFile().mkdirs();
            visualizer.export(this.getTarget());
            this.getLog().info((CharSequence)("Dependency graph exported to: " + this.getTarget()));
        }
        catch (DependencyTreeBuilderException e) {
            throw new MojoExecutionException("Could not build the dependency tree.", (Exception)((Object)e));
        }
    }

    protected void collectProjects(ArrayList<MavenProject> projects) {
        projects.add(this.project);
    }

    public File getTarget() {
        return this.target;
    }
}

