/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.graph;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.fusesource.mvnplugins.graph.DependencyVisualizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectMojo
extends AbstractMojo {
    private MavenProject project;
    private ArtifactRepository localRepository;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder treeBuilder;
    private File target;
    private boolean hideOmitted;
    private boolean hideOptional;
    private boolean hidePoms;
    private String hideScopes;
    private boolean hideTransitive;
    private String label;
    boolean cascade;
    String direction;

    public void execute() throws MojoExecutionException {
        try {
            DependencyVisualizer visualizer = new DependencyVisualizer();
            visualizer.cascade = this.cascade;
            visualizer.direction = this.direction;
            visualizer.hideOptional = this.hideOptional;
            visualizer.hidePoms = this.hidePoms;
            visualizer.hideOmitted = this.hideOmitted;
            visualizer.label = this.label;
            visualizer.hideTransitive = this.hideTransitive;
            visualizer.log = this.getLog();
            if (this.hideScopes != null) {
                for (String scope : this.hideScopes.split(",")) {
                    visualizer.hideScopes.add(scope);
                }
            }
            ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
            this.collectProjects(projects);
            for (MavenProject p : projects) {
                ArtifactFilter filter = null;
                DependencyNode node = this.treeBuilder.buildDependencyTree(p, this.localRepository, this.artifactFactory, this.artifactMetadataSource, filter, this.artifactCollector);
                visualizer.add(node);
            }
            this.getTarget().getParentFile().mkdirs();
            visualizer.export(this.getTarget());
            this.getLog().info((CharSequence)("Dependency graph exported to: " + this.getTarget()));
        }
        catch (DependencyTreeBuilderException e) {
            throw new MojoExecutionException("Could not build the depedency tree.", (Exception)((Object)e));
        }
    }

    protected void collectProjects(ArrayList<MavenProject> projects) {
        projects.add(this.project);
    }

    public File getTarget() {
        return this.target;
    }
}

