/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.linkchecker;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.linkcheck.HttpBean;
import org.apache.maven.doxia.linkcheck.LinkCheck;
import org.apache.maven.doxia.linkcheck.LinkCheckException;
import org.apache.maven.doxia.linkcheck.model.LinkcheckFile;
import org.apache.maven.doxia.linkcheck.model.LinkcheckFileResult;
import org.apache.maven.doxia.linkcheck.model.LinkcheckModel;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public class LinkcheckReport
extends AbstractMavenReport {
    private I18N i18n;
    private Renderer siteRenderer;
    private LinkCheck linkCheck;
    private MavenProject project;
    private ArtifactRepository localRepository;
    private File outputDirectory;
    private Settings settings;
    private boolean offline;
    private boolean httpFollowRedirect;
    protected File linkcheckCache;
    protected File linkcheckOutput;
    private String httpMethod;
    private int[] excludedHttpStatusErrors;
    private int[] excludedHttpStatusWarnings;
    private String[] excludedPages;
    private String[] excludedLinks;
    private String encoding;
    private Properties httpClientParameters;
    private int timeout;
    private boolean skip;
    private boolean forceSite;
    private String baseURL;
    private File basedir;
    private LinkcheckModel result;

    public String getDescription(Locale locale) {
        return this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.description");
    }

    public String getName(Locale locale) {
        return this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.name");
    }

    public String getOutputName() {
        return "sitegen-linkcheck";
    }

    public boolean canGenerateReport() {
        return !this.skip;
    }

    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            return;
        }
        if (StringUtils.isEmpty((String)this.encoding)) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
            this.encoding = ReaderFactory.FILE_ENCODING;
        }
        List documents = null;
        try {
            documents = FileUtils.getFiles((File)this.basedir, (String)"**/*.html", null);
        }
        catch (IOException e) {
            String msg = "IOException: " + e.getMessage();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)msg, (Throwable)e);
            }
            this.getLog().error((CharSequence)msg);
        }
        if (documents == null || documents != null && documents.size() == 0) {
            throw new MojoExecutionException("No site generated yet.");
        }
        try {
            this.result = this.executeLinkCheck(this.basedir);
        }
        catch (LinkCheckException e) {
            throw new MojoExecutionException("LinkCheckException: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (this.result == null) {
            this.getLog().debug((CharSequence)"Calling execute()");
            try {
                this.execute();
            }
            catch (MojoExecutionException e) {
                throw new MavenReportException("MojoExecutionException: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        if (this.result != null) {
            this.generateReport(locale, this.result);
            this.result = null;
        }
    }

    private LinkcheckModel executeLinkCheck(File basedir) throws LinkCheckException {
        Proxy proxy;
        this.linkCheck.setOnline(!this.offline);
        this.linkCheck.setBasedir(basedir);
        this.linkCheck.setBaseURL(this.baseURL);
        this.linkCheck.setReportOutput(this.linkcheckOutput);
        this.linkCheck.setLinkCheckCache(this.linkcheckCache);
        this.linkCheck.setExcludedLinks(this.excludedLinks);
        this.linkCheck.setExcludedPages(this.getExcludedPages());
        this.linkCheck.setExcludedHttpStatusErrors(this.excludedHttpStatusErrors);
        this.linkCheck.setExcludedHttpStatusWarnings(this.excludedHttpStatusWarnings);
        this.linkCheck.setEncoding(StringUtils.isNotEmpty((String)this.encoding) ? this.encoding : "UTF-8");
        HttpBean bean = new HttpBean();
        bean.setMethod(this.httpMethod);
        bean.setFollowRedirects(this.httpFollowRedirect);
        bean.setTimeout(this.timeout);
        if (this.httpClientParameters != null) {
            bean.setHttpClientParameters(this.httpClientParameters);
        }
        if ((proxy = this.settings.getActiveProxy()) != null) {
            bean.setProxyHost(proxy.getHost());
            bean.setProxyPort(proxy.getPort());
            bean.setProxyUser(proxy.getUsername());
            bean.setProxyPassword(proxy.getPassword());
        }
        this.linkCheck.setHttp(bean);
        return this.linkCheck.execute();
    }

    private String[] getExcludedPages() {
        ArrayList<String> pagesToExclude = this.excludedPages != null ? new ArrayList<String>(Arrays.asList(this.excludedPages)) : new ArrayList();
        pagesToExclude.add(this.getOutputName() + ".html");
        return pagesToExclude.toArray(new String[0]);
    }

    private void generateReport(Locale locale, LinkcheckModel linkcheckModel) {
        this.getSink().head();
        this.getSink().title();
        this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.title"));
        this.getSink().title_();
        this.getSink().head_();
        this.getSink().body();
        if (linkcheckModel == null) {
            this.getSink().section1();
            this.getSink().sectionTitle1();
            this.getSink().text(this.getName(locale));
            this.getSink().sectionTitle1_();
            this.getSink().paragraph();
            this.getSink().rawText(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.empty"));
            this.getSink().paragraph_();
            this.getSink().section1_();
            this.getSink().body_();
            this.getSink().flush();
            this.getSink().close();
            return;
        }
        this.getSink().section1();
        this.getSink().sectionTitle1();
        this.getSink().text(this.getName(locale));
        this.getSink().sectionTitle1_();
        this.getSink().paragraph();
        this.getSink().rawText(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.overview"));
        this.getSink().paragraph_();
        this.getSink().section1_();
        this.generateSummarySection(locale, linkcheckModel);
        if (linkcheckModel.getFiles().size() > 0) {
            this.generateDetailsSection(locale, linkcheckModel);
        }
        this.getSink().body_();
        this.getSink().flush();
        this.getSink().close();
        this.closeReport();
    }

    private void generateSummarySection(Locale locale, LinkcheckModel linkcheckModel) {
        List linkcheckFiles = linkcheckModel.getFiles();
        int totalFiles = linkcheckFiles.size();
        int totalLinks = 0;
        int totalValidLinks = 0;
        int totalErrorLinks = 0;
        int totalWarningLinks = 0;
        for (LinkcheckFile linkcheckFile : linkcheckFiles) {
            totalLinks += linkcheckFile.getNumberOfLinks();
            totalValidLinks += linkcheckFile.getNumberOfLinks(3);
            totalErrorLinks += linkcheckFile.getNumberOfLinks(1);
            totalWarningLinks += linkcheckFile.getNumberOfLinks(2);
        }
        this.getSink().section1();
        this.getSink().sectionTitle1();
        this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary"));
        this.getSink().sectionTitle1_();
        this.getSink().paragraph();
        this.getSink().rawText(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.overview1"));
        this.getSink().paragraph_();
        this.getSink().table();
        this.getSink().tableRow();
        this.getSink().tableHeaderCell();
        this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.parameter"));
        this.getSink().tableHeaderCell_();
        this.getSink().tableHeaderCell();
        this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.value"));
        this.getSink().tableHeaderCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().rawText(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.httpFollowRedirect"));
        this.getSink().tableCell_();
        this.getSink().tableCell();
        this.getSink().text(String.valueOf(this.httpFollowRedirect));
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().rawText(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.httpMethod"));
        this.getSink().tableCell_();
        this.getSink().tableCell();
        if (StringUtils.isEmpty((String)this.httpMethod)) {
            this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.none"));
        } else {
            this.getSink().text(this.httpMethod);
        }
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().rawText(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.offline"));
        this.getSink().tableCell_();
        this.getSink().tableCell();
        this.getSink().text(String.valueOf(this.offline));
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().rawText(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.excludedPages"));
        this.getSink().tableCell_();
        this.getSink().tableCell();
        if (this.getExcludedPages() == null || this.getExcludedPages().length == 0) {
            this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.none"));
        } else {
            this.getSink().text(StringUtils.join((Object[])this.getExcludedPages(), (String)","));
        }
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().rawText(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.excludedLinks"));
        this.getSink().tableCell_();
        this.getSink().tableCell();
        if (this.excludedLinks == null || this.excludedLinks.length == 0) {
            this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.none"));
        } else {
            this.getSink().text(StringUtils.join((Object[])this.excludedLinks, (String)","));
        }
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().rawText(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.excludedHttpStatusErrors"));
        this.getSink().tableCell_();
        this.getSink().tableCell();
        if (this.excludedHttpStatusErrors == null || this.excludedHttpStatusErrors.length == 0) {
            this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.none"));
        } else {
            this.getSink().text(LinkcheckReport.toString(this.excludedHttpStatusErrors));
        }
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().rawText(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.excludedHttpStatusWarnings"));
        this.getSink().tableCell_();
        this.getSink().tableCell();
        if (this.excludedHttpStatusWarnings == null || this.excludedHttpStatusWarnings.length == 0) {
            this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.none"));
        } else {
            this.getSink().text(LinkcheckReport.toString(this.excludedHttpStatusWarnings));
        }
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().table_();
        this.getSink().paragraph();
        this.getSink().rawText(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.overview2"));
        this.getSink().paragraph_();
        this.getSink().table();
        this.generateTableHeader(locale, false);
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().bold();
        this.getSink().text(totalFiles + "");
        this.getSink().bold_();
        this.getSink().tableCell_();
        this.getSink().tableCell();
        this.getSink().bold();
        this.getSink().text(totalLinks + "");
        this.getSink().bold_();
        this.getSink().tableCell_();
        this.getSink().tableCell();
        this.getSink().bold();
        this.getSink().text(String.valueOf(totalValidLinks));
        this.getSink().bold_();
        this.getSink().tableCell_();
        this.getSink().tableCell();
        this.getSink().bold();
        this.getSink().text(String.valueOf(totalWarningLinks));
        this.getSink().bold_();
        this.getSink().tableCell_();
        this.getSink().tableCell();
        this.getSink().bold();
        this.getSink().text(String.valueOf(totalErrorLinks));
        this.getSink().bold_();
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().table_();
        this.getSink().section1_();
    }

    private void generateDetailsSection(Locale locale, LinkcheckModel linkcheckModel) {
        this.getSink().section1();
        this.getSink().sectionTitle1();
        this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.detail"));
        this.getSink().sectionTitle1_();
        this.getSink().paragraph();
        this.getSink().rawText(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.detail.overview"));
        this.getSink().paragraph_();
        this.getSink().table();
        this.generateTableHeader(locale, true);
        List linkcheckFiles = linkcheckModel.getFiles();
        for (LinkcheckFile linkcheckFile : linkcheckFiles) {
            this.getSink().tableRow();
            this.getSink().tableCell();
            if (linkcheckFile.getUnsuccessful() == 0) {
                this.iconValid(locale);
            } else {
                this.iconError(locale);
            }
            this.getSink().tableCell_();
            this.getSink().tableCell();
            this.getSink().link(linkcheckFile.getRelativePath());
            this.getSink().text(linkcheckFile.getRelativePath());
            this.getSink().link_();
            this.getSink().tableCell_();
            this.getSink().tableCell();
            this.getSink().text(String.valueOf(linkcheckFile.getNumberOfLinks()));
            this.getSink().tableCell_();
            this.getSink().tableCell();
            this.getSink().text(String.valueOf(linkcheckFile.getNumberOfLinks(3)));
            this.getSink().tableCell_();
            this.getSink().tableCell();
            this.getSink().text(String.valueOf(linkcheckFile.getNumberOfLinks(2)));
            this.getSink().tableCell_();
            this.getSink().tableCell();
            this.getSink().text(String.valueOf(linkcheckFile.getNumberOfLinks(1)));
            this.getSink().tableCell_();
            this.getSink().tableRow_();
            if (linkcheckFile.getUnsuccessful() == 0) continue;
            this.getSink().tableRow();
            this.getSink().tableCell();
            this.getSink().text("");
            this.getSink().tableCell_();
            this.getSink().rawText("<td colspan=\"5\">");
            this.getSink().table();
            for (LinkcheckFileResult linkcheckFileResult : linkcheckFile.getResults()) {
                if (linkcheckFileResult.getStatusLevel() == 3) continue;
                this.getSink().tableRow();
                this.getSink().tableCell();
                if (linkcheckFileResult.getStatusLevel() == 2) {
                    this.iconWarning(locale);
                } else if (linkcheckFileResult.getStatusLevel() == 1) {
                    this.iconError(locale);
                }
                this.getSink().tableCell_();
                this.getSink().tableCell();
                this.getSink().italic();
                if (linkcheckFileResult.getTarget().startsWith("#")) {
                    this.getSink().link(linkcheckFile.getRelativePath() + linkcheckFileResult.getTarget());
                } else if (linkcheckFileResult.getTarget().startsWith(".")) {
                    String absolutePath = FilenameUtils.getFullPath((String)linkcheckFile.getRelativePath()) + linkcheckFileResult.getTarget();
                    String normalizedPath = FilenameUtils.normalize((String)absolutePath);
                    if (normalizedPath == null) {
                        normalizedPath = absolutePath;
                    }
                    this.getSink().link(normalizedPath);
                } else {
                    this.getSink().link(linkcheckFileResult.getTarget());
                }
                this.getSink().text(linkcheckFileResult.getTarget());
                this.getSink().link_();
                this.getSink().text(": ");
                this.getSink().text(linkcheckFileResult.getErrorMessage());
                this.getSink().italic_();
                this.getSink().tableCell_();
                this.getSink().tableRow_();
            }
            this.getSink().table_();
            this.getSink().tableCell_();
            this.getSink().tableRow_();
        }
        this.getSink().table_();
        this.getSink().section1_();
    }

    private void generateTableHeader(Locale locale, boolean detail) {
        this.getSink().tableRow();
        if (detail) {
            this.getSink().rawText("<th rowspan=\"2\">");
            this.getSink().text("");
            this.getSink().tableHeaderCell_();
        }
        this.getSink().rawText("<th rowspan=\"2\">");
        this.getSink().text(detail ? this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.detail.table.documents") : this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.summary.table.documents"));
        this.getSink().tableHeaderCell_();
        this.getSink().rawText("<th colspan=\"4\" align=\"center\">");
        this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.table.links"));
        this.getSink().tableHeaderCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableHeaderCell();
        this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.table.totalLinks"));
        this.getSink().tableHeaderCell_();
        this.getSink().tableHeaderCell();
        this.iconValid(locale);
        this.getSink().tableHeaderCell_();
        this.getSink().tableHeaderCell();
        this.iconWarning(locale);
        this.getSink().tableHeaderCell_();
        this.getSink().tableHeaderCell();
        this.iconError(locale);
        this.getSink().tableHeaderCell_();
        this.getSink().tableRow_();
    }

    private void iconError(Locale locale) {
        this.getSink().figure();
        this.getSink().figureCaption();
        this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.icon.error"));
        this.getSink().figureCaption_();
        this.getSink().figureGraphics("images/icon_error_sml.gif");
        this.getSink().figure_();
    }

    private void iconValid(Locale locale) {
        this.getSink().figure();
        this.getSink().figureCaption();
        this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.icon.valid"));
        this.getSink().figureCaption_();
        this.getSink().figureGraphics("images/icon_success_sml.gif");
        this.getSink().figure_();
    }

    private void iconWarning(Locale locale) {
        this.getSink().figure();
        this.getSink().figureCaption();
        this.getSink().text(this.i18n.getString("sitegen-linkcheck-report", locale, "report.sitegen.linkcheck.icon.warning"));
        this.getSink().figureCaption_();
        this.getSink().figureGraphics("images/icon_warning_sml.gif");
        this.getSink().figure_();
    }

    private static String toString(int[] a) {
        if (a == null || a.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ");
            buf.append(a[i]);
        }
        return buf.toString();
    }
}

