/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.notices;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.DefaultModelWriter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeNoticesMojo
extends AbstractMojo {
    private MavenProject project;
    private File repository;
    private String projectName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Model model = this.project.getOriginalModel();
            model.setPackaging("jar");
            model.setProfiles(null);
            model.setBuild(null);
            model.setArtifactId(model.getArtifactId() + "-dependencies");
            String projectVersion = this.project.getVersion();
            model.setDependencies(this.loadDependenciesFromRepo());
            Build build = new Build();
            build.addPlugin(this.createShadePlugin());
            model.setBuild(build);
            String targetDir = this.project.getBasedir() + File.separator + "target";
            File f = new File(targetDir, "dependency-pom.xml");
            if (f.exists()) {
                f.delete();
            }
            DefaultModelWriter writer = new DefaultModelWriter();
            writer.write(f, null, model);
            this.buildProject(f);
            String jarFile = targetDir + File.separator + "target" + File.separator + model.getArtifactId() + "-" + projectVersion + ".jar";
            this.extractNotice(targetDir, jarFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MavenInvocationException e) {
            e.printStackTrace();
        }
    }

    private List<Dependency> loadDependenciesFromRepo() {
        System.out.println(this.repository);
        Iterator jars = FileUtils.listFiles((File)this.repository, (String[])new String[]{"jar"}, (boolean)true).iterator();
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        while (jars.hasNext()) {
            File jar = (File)jars.next();
            String version = jar.getParentFile().getName();
            String artifactId = jar.getParentFile().getParentFile().getName();
            String groupIdSep = StringUtils.replace((String)jar.getParentFile().getParentFile().getParentFile().getPath(), (String)this.repository.getPath(), (String)"");
            String groupId = groupIdSep.replace(File.separatorChar, '.');
            groupId = groupId.startsWith(".") ? groupId.substring(1) : groupId;
            groupId = groupId.endsWith(".") ? groupId.substring(0, groupId.length() - 1) : groupId;
            Dependency dep = new Dependency();
            dep.setArtifactId(artifactId);
            dep.setGroupId(groupId);
            dep.setVersion(version);
            deps.add(dep);
        }
        return deps;
    }

    private void extractNotice(String destination, String jarFile) throws IOException, FileNotFoundException {
        try {
            ZipEntry entry;
            BufferedOutputStream dest = null;
            FileInputStream fis = new FileInputStream(jarFile);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                if (!"META-INF/NOTICE".equals(entry.getName())) continue;
                byte[] data = new byte[2048];
                File metaInf = new File(destination + File.separator + "META-INF");
                metaInf.mkdir();
                FileOutputStream fos = new FileOutputStream(destination + File.separator + entry.getName());
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                break;
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildProject(File f) throws MavenInvocationException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(f);
        request.setBaseDirectory(f.getParentFile());
        request.setGoals(Collections.singletonList("package"));
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.execute((InvocationRequest)request);
    }

    private Plugin createShadePlugin() {
        Plugin shade = new Plugin();
        shade.setArtifactId("maven-shade-plugin");
        shade.setVersion("1.4");
        PluginExecution pluginExecution = new PluginExecution();
        pluginExecution.addGoal("shade");
        pluginExecution.setPhase("package");
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom filters = new Xpp3Dom("filters");
        configuration.addChild(filters);
        Xpp3Dom filter = new Xpp3Dom("filter");
        filters.addChild(filter);
        Xpp3Dom artifact = new Xpp3Dom("artifact");
        artifact.setValue("*:*");
        filter.addChild(artifact);
        Xpp3Dom excludes = new Xpp3Dom("excludes");
        filter.addChild(excludes);
        Xpp3Dom exclude = new Xpp3Dom("exclude");
        exclude.setValue("org/**");
        excludes.addChild(exclude);
        Xpp3Dom includes = new Xpp3Dom("includes");
        filter.addChild(includes);
        Xpp3Dom include = new Xpp3Dom("include");
        include.setValue("META-INF/**");
        includes.addChild(include);
        Xpp3Dom transformers = new Xpp3Dom("transformers");
        configuration.addChild(transformers);
        Xpp3Dom transformer = new Xpp3Dom("transformer");
        transformer.setAttribute("implementation", "org.apache.maven.plugins.shade.resource.ApacheNoticeResourceTransformer");
        Xpp3Dom projectNameElement = new Xpp3Dom("projectName");
        projectNameElement.setValue(this.projectName);
        transformer.addChild(projectNameElement);
        transformers.addChild(transformer);
        pluginExecution.setConfiguration((Object)configuration);
        shade.addExecution(pluginExecution);
        return shade;
    }
}

