/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.notices.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.DefaultModelReader;
import org.apache.maven.model.io.DefaultModelWriter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyPom {
    private MavenProject project;
    private Model model;
    private String projectVersion;
    private File file;

    public DependencyPom(MavenProject project) {
        this.project = project;
        this.model = project.getOriginalModel();
        this.model.setPackaging("jar");
        this.model.setProfiles(null);
        this.model.setBuild(null);
        this.model.setArtifactId(this.model.getArtifactId() + "-dependencies");
        this.projectVersion = project.getVersion();
        Build build = new Build();
        this.model.setBuild(build);
    }

    public void addPlugin(Plugin plugin) {
        this.model.getBuild().addPlugin(plugin);
    }

    public void generatePom(String repositories, String targetDir) throws IOException {
        this.model.setDependencies(this.loadDependenciesFromRepos(repositories));
        this.file = new File(targetDir, "dependency-pom.xml");
        if (this.file.exists()) {
            this.file.delete();
        }
        DefaultModelWriter writer = new DefaultModelWriter();
        writer.write(this.file, null, this.model);
    }

    public File buildPom() throws MavenInvocationException {
        if (this.file != null) {
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setPomFile(this.file);
            request.setBaseDirectory(this.file.getParentFile());
            request.setGoals(Collections.singletonList("package"));
            DefaultInvoker invoker = new DefaultInvoker();
            invoker.execute((InvocationRequest)request);
            return new File(this.project.getBasedir() + File.separator + "target" + File.separator + "target" + File.separator + this.model.getArtifactId() + "-" + this.projectVersion + ".jar");
        }
        return null;
    }

    private List<Dependency> loadDependenciesFromRepos(String repositories) {
        if (repositories.contains(",")) {
            ArrayList<Dependency> deps = new ArrayList<Dependency>();
            for (String repo : repositories.split(",")) {
                deps.addAll(this.loadDependenciesFromRepo(new File(repo)));
            }
            return deps;
        }
        return this.loadDependenciesFromRepo(new File(repositories));
    }

    private List<Dependency> loadDependenciesFromRepo(File repo) {
        Iterator jars = FileUtils.listFiles((File)repo, (String[])new String[]{"jar"}, (boolean)true).iterator();
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        while (jars.hasNext()) {
            File jar = (File)jars.next();
            Dependency dependencyFromJar = this.dependencyFromJar(jar, repo);
            if (dependencyFromJar == null) continue;
            deps.add(dependencyFromJar);
        }
        return deps;
    }

    private Model getPom(File jar) {
        try {
            ZipEntry entry;
            ZipFile zip = new ZipFile(jar);
            FileInputStream fis = new FileInputStream(jar);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().startsWith("META-INF") || !entry.getName().endsWith("pom.xml")) continue;
                DefaultModelReader reader = new DefaultModelReader();
                InputStream inputStream = zip.getInputStream(entry);
                Model pom = reader.read(inputStream, null);
                inputStream.close();
                return pom;
            }
            zis.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Properties getPomProperties(File jar) {
        try {
            ZipEntry entry;
            ZipFile zip = new ZipFile(jar);
            FileInputStream fis = new FileInputStream(jar);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().startsWith("META-INF") || !entry.getName().endsWith("pom.properties")) continue;
                Properties props = new Properties();
                InputStream inputStream = zip.getInputStream(entry);
                props.load(inputStream);
                inputStream.close();
                return props;
            }
            zis.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Dependency dependencyFromJar(File jar, File repo) {
        Model pom = this.getPom(jar);
        Properties props = this.getPomProperties(jar);
        Dependency dep = new Dependency();
        if (props != null) {
            dep.setArtifactId(props.getProperty("artifactId"));
            dep.setGroupId(props.getProperty("groupId"));
            dep.setVersion(props.getProperty("version"));
        } else if (pom != null) {
            dep.setArtifactId(pom.getArtifactId());
            dep.setGroupId(pom.getGroupId());
            dep.setVersion(pom.getVersion());
        } else {
            return null;
        }
        return dep;
    }
}

