/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.notices.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.DefaultModelReader;
import org.apache.maven.model.io.DefaultModelWriter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.downloader.Downloader;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamHandler;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyPom {
    private MavenProject project;
    private Downloader downloader;
    private Model model;
    private String projectVersion;
    private File file;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteArtifactRepositories;
    private List<Dependency> extraDependencies;

    public DependencyPom(MavenProject project, Downloader downloader, ArtifactRepository localRepository, List<ArtifactRepository> remoteArtifactRepositories, String extraDependencies, String defaultParent) {
        this.project = project;
        this.downloader = downloader;
        this.localRepository = localRepository;
        this.remoteArtifactRepositories = remoteArtifactRepositories;
        this.extraDependencies = new ArrayList<Dependency>();
        for (String depStr : extraDependencies.split(",")) {
            String[] depStrSplit = depStr.split(":");
            Dependency dep = new Dependency();
            dep.setGroupId(depStrSplit[0]);
            dep.setArtifactId(depStrSplit[1]);
            dep.setVersion(depStrSplit[2]);
            this.extraDependencies.add(dep);
        }
        this.model = project.getOriginalModel();
        this.model.setPackaging("jar");
        this.model.setProfiles(null);
        this.model.setBuild(null);
        this.model.setArtifactId(this.model.getArtifactId() + "-dependencies");
        this.projectVersion = project.getVersion();
        this.model.setVersion(this.projectVersion);
        this.setParent(defaultParent);
        Build build = new Build();
        this.model.setBuild(build);
    }

    private void setParent(String defaultParent) {
        String[] strings = defaultParent.split(":");
        this.model.getParent().setGroupId(strings[0]);
        this.model.getParent().setArtifactId(strings[1]);
        if ("VERSION".equals(strings[2])) {
            this.model.getParent().setVersion(this.projectVersion);
        } else {
            this.model.getParent().setVersion(strings[2]);
        }
    }

    public void addPlugin(Plugin plugin) {
        this.model.getBuild().addPlugin(plugin);
    }

    public void generatePom(String repositories, String targetDir) throws IOException {
        List<Dependency> loadDependenciesFromRepos = this.loadDependenciesFromRepos(repositories);
        loadDependenciesFromRepos.addAll(this.extraDependencies);
        this.model.setDependencies(loadDependenciesFromRepos);
        this.file = new File(targetDir, "dependency-pom.xml");
        if (this.file.exists()) {
            this.file.delete();
        }
        DefaultModelWriter writer = new DefaultModelWriter();
        writer.write(this.file, null, this.model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File buildPom() throws MavenInvocationException {
        if (this.file != null) {
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setPomFile(this.file);
            request.setBaseDirectory(this.file.getParentFile());
            request.setLocalRepositoryDirectory(new File(this.localRepository.getBasedir()));
            request.setGoals(Collections.singletonList("package"));
            PrintStream invokerLog = null;
            try {
                invokerLog = new PrintStream(new FileOutputStream(this.file.getAbsoluteFile().toString() + ".log"));
                request.setOutputHandler((InvocationOutputHandler)new PrintStreamHandler(invokerLog, false));
                DefaultInvoker invoker = new DefaultInvoker();
                invoker.execute((InvocationRequest)request);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (invokerLog != null) {
                    invokerLog.close();
                }
            }
            return new File(this.project.getBasedir() + File.separator + "target" + File.separator + "target" + File.separator + this.model.getArtifactId() + "-" + this.projectVersion + ".jar");
        }
        return null;
    }

    private List<Dependency> loadDependenciesFromRepos(String repositories) {
        if (repositories.contains(",")) {
            ArrayList<Dependency> deps = new ArrayList<Dependency>();
            for (String repo : repositories.split(",")) {
                deps.addAll(this.loadDependenciesFromRepo(new File(repo)));
            }
            return deps;
        }
        return this.loadDependenciesFromRepo(new File(repositories));
    }

    private List<Dependency> loadDependenciesFromRepo(File repo) {
        Iterator jars = FileUtils.listFiles((File)repo, (String[])new String[]{"jar"}, (boolean)true).iterator();
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        int currentJarNum = 0;
        while (jars.hasNext()) {
            Dependency dependencyFromJar;
            File jar = (File)jars.next();
            if (currentJarNum++ % 100 == 0) {
                System.gc();
                System.runFinalization();
            }
            if ((dependencyFromJar = this.dependencyFromJar(jar, repo)) == null) continue;
            deps.add(dependencyFromJar);
        }
        return deps;
    }

    private Model getPom(File jar) {
        try {
            ZipEntry entry;
            ZipFile zip = new ZipFile(jar);
            FileInputStream fis = new FileInputStream(jar);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().startsWith("META-INF") || !entry.getName().endsWith("pom.xml")) continue;
                DefaultModelReader reader = new DefaultModelReader();
                InputStream inputStream = zip.getInputStream(entry);
                Model pom = reader.read(inputStream, null);
                inputStream.close();
                return pom;
            }
            zis.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Properties getPomProperties(File jar) {
        try {
            ZipEntry entry;
            ZipFile zip = new ZipFile(jar);
            FileInputStream fis = new FileInputStream(jar);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().startsWith("META-INF") || !entry.getName().endsWith("pom.properties")) continue;
                Properties props = new Properties();
                InputStream inputStream = zip.getInputStream(entry);
                props.load(inputStream);
                inputStream.close();
                return props;
            }
            zis.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Dependency dependencyFromJar(File jar, File repo) {
        Model pom = this.getPom(jar);
        Properties props = this.getPomProperties(jar);
        Dependency dep = new Dependency();
        if (props != null) {
            dep.setArtifactId(props.getProperty("artifactId"));
            dep.setGroupId(props.getProperty("groupId"));
            dep.setVersion(props.getProperty("version"));
        } else if (pom != null) {
            dep.setArtifactId(pom.getArtifactId());
            dep.setGroupId(pom.getGroupId());
            dep.setVersion(pom.getVersion());
        } else {
            String version = jar.getParentFile().getName();
            String artifactId = jar.getParentFile().getParentFile().getName();
            String groupIdSep = StringUtils.replace((String)jar.getParentFile().getParentFile().getParentFile().getPath(), (String)repo.getPath(), (String)"");
            String groupId = groupIdSep.replace(File.separatorChar, '.');
            groupId = groupId.startsWith(".") ? groupId.substring(1) : groupId;
            groupId = groupId.endsWith(".") ? groupId.substring(0, groupId.length() - 1) : groupId;
            dep.setArtifactId(artifactId);
            dep.setGroupId(groupId);
            dep.setVersion(version);
        }
        try {
            this.downloader.download(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), this.localRepository, this.remoteArtifactRepositories);
        }
        catch (Exception e) {
            e.printStackTrace();
            dep = null;
        }
        return dep;
    }
}

