/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.notices.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.DefaultModelWriter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamHandler;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyPom {
    private MavenProject project;
    private Model model;
    private String projectVersion;
    private File file;
    private ArtifactRepository localRepository;
    private List<Dependency> extraDependencies;
    private MavenSession session;
    private List<Dependency> excludeDependencies;

    public DependencyPom(MavenProject project, ArtifactRepository localRepository, String extraDependencies, String defaultParent, String excludeDependencies) {
        Dependency dep;
        String[] depStrSplit;
        this.project = project;
        this.localRepository = localRepository;
        this.extraDependencies = new ArrayList<Dependency>();
        if (extraDependencies != null) {
            for (String depStr : extraDependencies.split(",")) {
                depStrSplit = depStr.split(":");
                dep = new Dependency();
                dep.setGroupId(depStrSplit[0]);
                dep.setArtifactId(depStrSplit[1]);
                dep.setVersion(depStrSplit[2]);
                this.extraDependencies.add(dep);
            }
        }
        this.excludeDependencies = new ArrayList<Dependency>();
        if (excludeDependencies != null) {
            for (String depStr : excludeDependencies.split(",")) {
                depStrSplit = depStr.split(":");
                dep = new Dependency();
                dep.setGroupId(depStrSplit[0]);
                dep.setArtifactId(depStrSplit[1]);
                this.excludeDependencies.add(dep);
            }
        }
        this.model = project.getOriginalModel();
        this.model.setPackaging("jar");
        this.model.setProfiles(null);
        this.model.setBuild(null);
        this.model.setArtifactId(this.model.getArtifactId() + "-dependencies");
        this.projectVersion = project.getVersion();
        this.model.setVersion(this.projectVersion);
        this.setParent(defaultParent);
        Build build = new Build();
        this.model.setBuild(build);
    }

    private void setParent(String defaultParent) {
        String[] strings;
        if (defaultParent != null && !defaultParent.equals("") && (strings = defaultParent.split(":")).length >= 3) {
            this.model.getParent().setGroupId(strings[0]);
            this.model.getParent().setArtifactId(strings[1]);
            if ("VERSION".equals(strings[2])) {
                this.model.getParent().setVersion(this.projectVersion);
            } else {
                this.model.getParent().setVersion(strings[2]);
            }
            if (strings.length == 4) {
                this.model.getParent().setRelativePath(strings[3]);
            } else {
                this.model.getParent().setRelativePath(null);
            }
        }
    }

    public void addPlugin(Plugin plugin) {
        this.model.getBuild().addPlugin(plugin);
    }

    public void generatePom(String repositories, String targetDir) throws IOException {
        List<Dependency> loadDependenciesFromRepos = this.loadDependenciesFromRepos(repositories);
        loadDependenciesFromRepos.addAll(this.extraDependencies);
        this.model.setDependencies(loadDependenciesFromRepos);
        this.project.getProperties().put("skipTests", "true");
        this.model.setProperties(this.project.getProperties());
        this.file = new File(targetDir, "dependency-pom.xml");
        if (this.file.exists()) {
            this.file.delete();
        }
        DefaultModelWriter writer = new DefaultModelWriter();
        writer.write(this.file, null, this.model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File buildPom() throws MavenInvocationException {
        if (this.file != null) {
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setPomFile(this.file);
            request.setBaseDirectory(this.file.getParentFile());
            request.setLocalRepositoryDirectory(new File(this.localRepository.getBasedir()));
            request.setGoals(Collections.singletonList("package"));
            LinkedList<String> profiles = new LinkedList<String>();
            for (Profile p : this.project.getActiveProfiles()) {
                profiles.add(p.getId());
            }
            request.setProfiles(profiles);
            request.setShellEnvironmentInherited(true);
            if (this.session.getRequest().getUserSettingsFile().exists()) {
                request.setUserSettingsFile(this.session.getRequest().getUserSettingsFile());
            }
            if (this.session.getRequest().getLoggingLevel() == 0) {
                request.setDebug(true);
            }
            request.setOffline(this.session.getRequest().isOffline());
            PrintStream invokerLog = null;
            InvocationResult invocationResult = null;
            try {
                invokerLog = new PrintStream(new FileOutputStream(this.file.getAbsoluteFile().toString() + ".log"));
                request.setOutputHandler((InvocationOutputHandler)new PrintStreamHandler(invokerLog, false));
                DefaultInvoker invoker = new DefaultInvoker();
                invocationResult = invoker.execute((InvocationRequest)request);
            }
            catch (FileNotFoundException e) {
            }
            finally {
                if (invokerLog != null) {
                    invokerLog.close();
                }
            }
            return new File(this.project.getBasedir() + File.separator + "target" + File.separator + "target" + File.separator + this.model.getArtifactId() + "-" + this.projectVersion + ".jar");
        }
        return null;
    }

    private List<Dependency> loadDependenciesFromRepos(String repositories) {
        if (repositories.contains(",")) {
            ArrayList<Dependency> deps = new ArrayList<Dependency>();
            for (String repo : repositories.split(",")) {
                List<Dependency> loadDependenciesFromRepo = this.loadDependenciesFromRepo(new File(repo));
                for (Dependency dep : loadDependenciesFromRepo) {
                    if (dep == null || this.dependencyExists(dep, deps)) continue;
                    deps.add(dep);
                }
            }
            return deps;
        }
        return this.loadDependenciesFromRepo(new File(repositories));
    }

    private List<Dependency> loadDependenciesFromRepo(File repo) {
        Iterator jars = FileUtils.listFiles((File)repo, (String[])new String[]{"jar"}, (boolean)true).iterator();
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        while (jars.hasNext()) {
            Dependency dependencyFromJar;
            File jar = (File)jars.next();
            if (jar.getName().contains("tests.jar") || jar.getName().contains("sources.jar") || jar.getName().contains("javadoc.jar") || jar.getName().contains("classes.jar") || (dependencyFromJar = this.dependencyFromJar(jar, repo)) == null || this.dependencyExists(dependencyFromJar, deps) || this.dependencyExists(dependencyFromJar, this.excludeDependencies)) continue;
            deps.add(dependencyFromJar);
        }
        return deps;
    }

    private boolean dependencyExists(Dependency dependencyFromJar, List<Dependency> deps) {
        for (Dependency dep : deps) {
            if (!dep.getGroupId().equals(dependencyFromJar.getGroupId()) || !dep.getArtifactId().equals(dependencyFromJar.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private Dependency dependencyFromJar(File jar, File repo) {
        Dependency dep = new Dependency();
        String version = jar.getParentFile().getName();
        String artifactId = jar.getParentFile().getParentFile().getName();
        String groupIdSep = StringUtils.replace((String)jar.getParentFile().getParentFile().getParentFile().getPath(), (String)repo.getPath(), (String)"");
        String groupId = groupIdSep.replace(File.separatorChar, '.');
        groupId = groupId.startsWith(".") ? groupId.substring(1) : groupId;
        groupId = groupId.endsWith(".") ? groupId.substring(0, groupId.length() - 1) : groupId;
        String fileName = jar.getName();
        int idxOfVersion = fileName.lastIndexOf(version);
        int idxOfLastDot = fileName.lastIndexOf(".");
        if (idxOfVersion > 0 && idxOfVersion + version.length() < idxOfLastDot && !fileName.contains("SNAPSHOT")) {
            String classifier = fileName.substring(idxOfVersion + version.length() + 1, idxOfLastDot);
            dep.setClassifier(classifier);
        }
        dep.setArtifactId(artifactId);
        dep.setGroupId(groupId);
        dep.setVersion(version);
        return dep;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }
}

