/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.notices;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.fusesource.mvnplugins.notices.util.DependencyPom;

public class MergeNoticesMojo
extends AbstractMojo {
    private MavenProject project;
    private ArtifactRepository localRepository;
    protected MavenSession session;
    private String repositories;
    private String projectName;
    private String preamble;
    private String organizationName;
    private String organizationURL;
    private boolean listDependencies;
    private boolean generateLicensesXml;
    private String extraDependencies;
    private String excludeDependencies;
    private String noticeSupplements;
    private String licensesConfigFile;
    private String defaultParent;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            long start = System.currentTimeMillis();
            DependencyPom pom = new DependencyPom(this.project, this.localRepository, this.extraDependencies, this.defaultParent, this.excludeDependencies);
            pom.setSession(this.session);
            pom.addPlugin(this.createShadePlugin());
            if (this.listDependencies) {
                pom.addPlugin(this.createRemoteResourcesPlugin());
            }
            if (this.generateLicensesXml) {
                pom.addPlugin(this.createJBossLicensePlugin());
            }
            String targetDir = this.project.getBasedir() + File.separator + "target";
            pom.generatePom(this.repositories, targetDir);
            File jarFile = pom.buildPom();
            if (jarFile.exists()) {
                if (this.generateLicensesXml) {
                    if (!new File(targetDir + File.separator + "target/maven-jboss-license-plugin/licenses.xml").exists()) {
                        this.getLog().error((CharSequence)IOUtil.toString((InputStream)new FileInputStream(targetDir + "/dependency-pom.xml.log")));
                        throw new MojoExecutionException("Could not generate license summary, please check target/dependency-pom.xml.log for details.");
                    }
                    this.getLog().info((CharSequence)("License summary saved as: " + targetDir + File.separator + "target/maven-jboss-license-plugin/licenses.xml"));
                }
                if (this.listDependencies) {
                    if (!new File(targetDir + File.separator + "target/maven-shared-archive-resources/META-INF/DEPENDENCIES").exists()) {
                        this.getLog().error((CharSequence)IOUtil.toString((InputStream)new FileInputStream(targetDir + "/dependency-pom.xml.log")));
                        throw new MojoExecutionException("Could not generate dependencies list, please check target/dependency-pom.xml.log for details.");
                    }
                    this.getLog().info((CharSequence)("Dependencies saved as:    " + targetDir + File.separator + "target/maven-shared-archive-resources/META-INF/DEPENDENCIES"));
                }
            } else {
                this.getLog().error((CharSequence)IOUtil.toString((InputStream)new FileInputStream(targetDir + "/dependency-pom.xml.log")));
                throw new MojoExecutionException("Could not generate notices, please check target/dependency-pom.xml.log for details.");
            }
            this.extractFile(targetDir, jarFile, "META-INF/NOTICE");
            this.getLog().info((CharSequence)("Notices generated in " + (System.currentTimeMillis() - start) + "ms."));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MavenInvocationException e) {
            e.printStackTrace();
        }
    }

    private void extractFile(String destination, File jarFile, String fileToExtract) throws IOException, FileNotFoundException {
        try {
            ZipEntry entry;
            BufferedOutputStream dest = null;
            FileInputStream fis = new FileInputStream(jarFile);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                if (!fileToExtract.equals(entry.getName())) continue;
                byte[] data = new byte[2048];
                File metaInf = new File(destination + File.separator + "META-INF");
                metaInf.mkdir();
                FileOutputStream fos = new FileOutputStream(destination + File.separator + entry.getName());
                this.getLog().info((CharSequence)("Notices saved as:         " + destination + File.separator + entry.getName()));
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                break;
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Plugin createShadePlugin() {
        Plugin shade = new Plugin();
        shade.setArtifactId("maven-shade-plugin");
        shade.setVersion("3.0.0");
        PluginExecution pluginExecution = new PluginExecution();
        pluginExecution.addGoal("shade");
        pluginExecution.setPhase("package");
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom artifactSet = new Xpp3Dom("artifactSet");
        configuration.addChild(artifactSet);
        Xpp3Dom artifactSetIncludes = new Xpp3Dom("includes");
        artifactSet.addChild(artifactSetIncludes);
        Xpp3Dom artifactSetInclude = new Xpp3Dom("include");
        artifactSetInclude.setValue("*:*:jar:*");
        artifactSetIncludes.addChild(artifactSetInclude);
        Xpp3Dom filters = new Xpp3Dom("filters");
        configuration.addChild(filters);
        Xpp3Dom filter = new Xpp3Dom("filter");
        filters.addChild(filter);
        Xpp3Dom artifact = new Xpp3Dom("artifact");
        artifact.setValue("*:*");
        filter.addChild(artifact);
        Xpp3Dom excludes = new Xpp3Dom("excludes");
        filter.addChild(excludes);
        Xpp3Dom exclude = new Xpp3Dom("exclude");
        exclude.setValue("org/**");
        excludes.addChild(exclude);
        Xpp3Dom includes = new Xpp3Dom("includes");
        filter.addChild(includes);
        Xpp3Dom include = new Xpp3Dom("include");
        include.setValue("META-INF/**");
        includes.addChild(include);
        Xpp3Dom transformers = new Xpp3Dom("transformers");
        configuration.addChild(transformers);
        Xpp3Dom transformer = new Xpp3Dom("transformer");
        transformer.setAttribute("implementation", "org.apache.maven.plugins.shade.resource.ApacheNoticeResourceTransformer");
        Xpp3Dom projectNameElement = new Xpp3Dom("projectName");
        projectNameElement.setValue(this.projectName);
        transformer.addChild(projectNameElement);
        Xpp3Dom organizationNameElement = new Xpp3Dom("organizationName");
        organizationNameElement.setValue(this.organizationName);
        transformer.addChild(organizationNameElement);
        Xpp3Dom organizationURLElement = new Xpp3Dom("organizationURL");
        organizationURLElement.setValue(this.organizationURL);
        transformer.addChild(organizationURLElement);
        Xpp3Dom preamble1Element = new Xpp3Dom("preamble1");
        preamble1Element.setValue(this.preamble);
        transformer.addChild(preamble1Element);
        transformers.addChild(transformer);
        pluginExecution.setConfiguration((Object)configuration);
        shade.addExecution(pluginExecution);
        return shade;
    }

    private Plugin createRemoteResourcesPlugin() {
        Plugin plugin = new Plugin();
        plugin.setArtifactId("maven-remote-resources-plugin");
        plugin.setVersion("1.5");
        PluginExecution pluginExecution = new PluginExecution();
        pluginExecution.addGoal("process");
        pluginExecution.setPhase("package");
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        this.addNestedElement(configuration, "resourceBundles", "resourceBundle", "org.apache:apache-jar-resource-bundle:1.4");
        this.addNestedElement(configuration, "supplementalModels", "supplementalModel", this.noticeSupplements);
        this.addNestedElement(configuration, "properties", "projectName", this.projectName);
        this.addElement(configuration, "excludeTransitive", "true");
        pluginExecution.setConfiguration((Object)configuration);
        plugin.addExecution(pluginExecution);
        return plugin;
    }

    private Plugin createJBossLicensePlugin() {
        Plugin plugin = new Plugin();
        plugin.setGroupId("org.codehaus.mojo");
        plugin.setArtifactId("license-maven-plugin");
        plugin.setVersion("1.12");
        PluginExecution pluginExecution = new PluginExecution();
        pluginExecution.addGoal("download-licenses");
        pluginExecution.setPhase("package");
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        if (!this.licensesConfigFile.isEmpty()) {
            this.addElement(configuration, "licensesConfigFile", this.licensesConfigFile);
        }
        this.addElement(configuration, "includeTransitiveDependencies", "false");
        this.addElement(configuration, "licensesOutputDirectory", "${project.build.directory}/maven-jboss-license-plugin");
        this.addElement(configuration, "licensesOutputFile", "${project.build.directory}/maven-jboss-license-plugin/licenses.xml");
        pluginExecution.setConfiguration((Object)configuration);
        plugin.addExecution(pluginExecution);
        return plugin;
    }

    private void addElement(Xpp3Dom parent, String name, String value) {
        Xpp3Dom artifactId = new Xpp3Dom(name);
        artifactId.setValue(value);
        parent.addChild(artifactId);
    }

    private void addNestedElement(Xpp3Dom root, String parent, String child, String value) {
        Xpp3Dom parentNode = new Xpp3Dom(parent);
        this.addElement(parentNode, child, value);
        root.addChild(parentNode);
    }
}

