/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.provision;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.FileUtils;

public class ProvisionMojo
extends AbstractMojo {
    private File outputDirectory;
    protected MavenProject project;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private boolean chmod;
    private String chmodMode;
    private String remoteServerId;
    private String remoteServerUrl;
    private String remoteDirectory;
    private String chmodOptions;
    private String mvOptions;
    private String oldBuildDateFormat = "yyyy-MM-dd-HH-mm-ss-SSS";
    private WagonManager wagonManager;
    private Settings settings;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.outputDirectory.exists()) {
            if (this.outputDirectory.isFile()) {
                throw new MojoExecutionException("Output directory is a file: " + this.outputDirectory);
            }
        } else {
            this.outputDirectory.mkdirs();
            if (!this.outputDirectory.exists() || !this.outputDirectory.isDirectory()) {
                throw new MojoExecutionException("Failed to create output directory: " + this.outputDirectory);
            }
        }
        Artifact a = this.project.getArtifact();
        String groupId = a.getGroupId();
        String artifactId = a.getArtifactId();
        String version = a.getVersion();
        String packaging = a.getType();
        this.getLog().debug((CharSequence)("Attempting to resolve: " + groupId + ":" + artifactId + ":" + version + ":" + packaging));
        Artifact toDownload = this.artifactFactory.createBuildArtifact(groupId, artifactId, version, packaging);
        List remoteArtifactRepositories = this.project.getRemoteArtifactRepositories();
        try {
            this.artifactResolver.resolve(toDownload, remoteArtifactRepositories, this.localRepository);
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)((Object)e));
        }
        File file = toDownload.getFile();
        File destFile = new File(this.outputDirectory, file.getName());
        try {
            this.getLog().info((CharSequence)("Copying " + file.getName() + " to " + destFile));
            FileUtils.copyFile((File)file, (File)destFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error copying artifact from " + file + " to " + destFile, e);
        }
    }
}

