/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.provision;

import java.io.File;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public class ProvisionMojo
extends AbstractMojo {
    private File outputDirectory;
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().debug((CharSequence)"Ignoring pom packaging");
            return;
        }
        Build build = this.project.getBuild();
        if (build == null) {
            this.getLog().debug((CharSequence)"No Build available in this Project");
            return;
        }
        File file = new File(build.getDirectory(), build.getFinalName() + "." + this.getArtifactExtension());
        this.getLog().debug((CharSequence)("Trying to detect: " + file.getAbsolutePath()));
        if (file.exists()) {
            File destFile = new File(this.outputDirectory, file.getName());
            try {
                this.getLog().info((CharSequence)("Copying " + file.getName() + " to " + destFile));
                FileUtils.copyFile((File)file, (File)destFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error copying artifact from " + file + " to " + destFile, e);
            }
        } else {
            this.getLog().info((CharSequence)("Artifact does not exist so cannot be provisioned: " + file.getPath()));
        }
    }

    private String getArtifactExtension() {
        String packaging = this.project.getPackaging();
        if ("bundle".equals(packaging)) {
            return "jar";
        }
        return packaging;
    }
}

