/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.uberize.transformer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.fusesource.mvnplugins.uberize.DefaultUberizer;
import org.fusesource.mvnplugins.uberize.Transformer;
import org.fusesource.mvnplugins.uberize.UberEntry;
import org.fusesource.mvnplugins.uberize.Uberizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransformer
implements Transformer {
    @Override
    public void process(Uberizer uberizer, File workDir, TreeMap<String, UberEntry> uberEntries) throws IOException {
        for (UberEntry entry : new ArrayList<UberEntry>(uberEntries.values())) {
            String entryPath;
            if (entry.getSources().isEmpty() || !this.matches(entryPath = entry.getPath())) continue;
            File target = DefaultUberizer.prepareFile(workDir, entryPath);
            UberEntry modEntry = this.process(uberizer, entry, target);
            if (modEntry != null) {
                uberEntries.put(entryPath, modEntry);
                continue;
            }
            uberEntries.remove(entryPath);
        }
    }

    protected abstract boolean matches(String var1);

    protected abstract UberEntry process(Uberizer var1, UberEntry var2, File var3) throws IOException;
}

