/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.uberize.transformer;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.fusesource.mvnplugins.uberize.DefaultUberizer;
import org.fusesource.mvnplugins.uberize.Transformer;
import org.fusesource.mvnplugins.uberize.UberEntry;
import org.fusesource.mvnplugins.uberize.Uberizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlexusComponents
implements Transformer {
    public static final String COMPONENTS_XML_PATH = "META-INF/plexus/components.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Uberizer uberizer, File workDir, TreeMap<String, UberEntry> uberEntries) throws IOException {
        UberEntry uberEntry = uberEntries.get(COMPONENTS_XML_PATH);
        if (uberEntry == null || uberEntry.getSources().size() <= 1) {
            return;
        }
        LinkedHashMap<String, Xpp3Dom> components = this.merge(uberEntry.getSources());
        File aggregatedFile = DefaultUberizer.prepareFile(workDir, COMPONENTS_XML_PATH);
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)aggregatedFile);
        try {
            Xpp3Dom dom = new Xpp3Dom("component-set");
            Xpp3Dom componentDom = new Xpp3Dom("components");
            dom.addChild(componentDom);
            for (Xpp3Dom component : components.values()) {
                componentDom.addChild(component);
            }
            Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)dom);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
        UberEntry modEntry = new UberEntry(uberEntry);
        modEntry.getSources().add(aggregatedFile);
        uberEntries.put(modEntry.getPath(), modEntry);
    }

    private LinkedHashMap<String, Xpp3Dom> merge(List<File> files) throws IOException {
        LinkedHashMap<String, Xpp3Dom> components = new LinkedHashMap<String, Xpp3Dom>();
        for (File file : files) {
            Xpp3Dom dom;
            try {
                dom = Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((File)file));
            }
            catch (Exception e) {
                throw new IOException("Error parsing components.xml in " + file);
            }
            if (dom.getChild("components") == null) continue;
            for (Xpp3Dom component : dom.getChild("components").getChildren("component")) {
                String role = component.getChild("role").getValue();
                Xpp3Dom child = component.getChild("role-hint");
                String roleHint = child != null ? child.getValue() : "";
                String key = role + roleHint;
                Xpp3Dom previous = components.get(key);
                if (previous != null && previous.getChild("configuration") != null) {
                    component.addChild(previous.getChild("configuration"));
                }
                components.put(key, component);
            }
        }
        return components;
    }
}

