/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.uberize;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UberEntry {
    private final String path;
    private final ArrayList<File> sources = new ArrayList();
    private final List<UberEntry> previous;

    public UberEntry(String path) {
        this(path, (List<UberEntry>)null);
    }

    public UberEntry(UberEntry previous) {
        this(previous.getPath(), previous);
    }

    public UberEntry(String path, UberEntry previous) {
        this.path = path;
        this.previous = UberEntry.toList(previous);
    }

    private static List<UberEntry> toList(UberEntry entry) {
        if (entry == null) {
            return null;
        }
        ArrayList<UberEntry> rc = new ArrayList<UberEntry>(1);
        rc.add(entry);
        return rc;
    }

    public UberEntry(String path, List<UberEntry> previous) {
        this.path = path;
        this.previous = previous;
    }

    public ArrayList<File> getSources() {
        return this.sources;
    }

    public String getPath() {
        return this.path;
    }

    public UberEntry getPrevious() {
        if (this.previous == null || this.previous.isEmpty()) {
            return null;
        }
        return this.previous.get(0);
    }

    public List<UberEntry> getAllPrevious() {
        if (this.previous == null) {
            return null;
        }
        return this.previous;
    }

    public UberEntry addSource(File file) {
        this.sources.add(file);
        return this;
    }
}

