/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.uberize.relocation;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.util.SelectorUtils;
import org.fusesource.mvnplugins.uberize.relocation.Relocator;

public class SimpleRelocator
implements Relocator {
    private String pattern;
    private String pathPattern;
    private String shadedPattern;
    private String shadedPathPattern;
    private Set excludes;

    public SimpleRelocator(String patt, String shadedPattern, List excludes) {
        this.pattern = patt.replace('/', '.');
        this.pathPattern = patt.replace('.', '/');
        if (shadedPattern != null) {
            this.shadedPattern = shadedPattern.replace('/', '.');
            this.shadedPathPattern = shadedPattern.replace('.', '/');
        } else {
            this.shadedPattern = "hidden." + this.pattern;
            this.shadedPathPattern = "hidden/" + this.pathPattern;
        }
        if (excludes != null && !excludes.isEmpty()) {
            this.excludes = new LinkedHashSet();
            for (String e : excludes) {
                String classExclude = e.replace('.', '/');
                this.excludes.add(classExclude);
                if (!classExclude.endsWith("/*")) continue;
                String packageExclude = classExclude.substring(0, classExclude.lastIndexOf(47));
                this.excludes.add(packageExclude);
            }
        }
    }

    public boolean canRelocatePath(String path) {
        if (path.endsWith(".class")) {
            path = path.substring(0, path.length() - 6);
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                if (!SelectorUtils.matchPath((String)exclude, (String)path, (boolean)true)) continue;
                return false;
            }
        }
        return path.startsWith(this.pathPattern);
    }

    public boolean canRelocateClass(String clazz) {
        return !clazz.contains("/") && this.canRelocatePath(clazz.replace('.', '/'));
    }

    public String relocatePath(String path) {
        return path.replaceFirst(this.pathPattern, this.shadedPathPattern);
    }

    public String relocateClass(String clazz) {
        return clazz.replaceFirst(this.pattern, this.shadedPattern);
    }
}

