/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.updatesite;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public class UpdateSiteDeployMojo
extends AbstractMojo
implements Contextualizable {
    private File inputDirectory;
    private String htaccessFileName;
    private boolean timestampDirectory;
    private boolean generateHtaccess;
    private String remotehtAccessFile;
    private boolean moveOldDirectory;
    private boolean chmod;
    private String chmodMode;
    private String remoteServerId;
    private String remoteServerUrl;
    private String remoteDirectory;
    private String chmodOptions;
    private String mvOptions;
    private String oldBuildDateFormat = "yyyy-MM-dd-HH-mm-ss-SSS";
    private MavenProject project;
    private WagonManager wagonManager;
    private Settings settings;
    private PlexusContainer container;

    public void execute() throws MojoExecutionException {
        Wagon wagon;
        if (!this.inputDirectory.exists()) {
            throw new MojoExecutionException("The site does not exist, please run site:site first");
        }
        String url = this.remoteServerUrl;
        String id = this.remoteServerId;
        if (id == null) {
            throw new MojoExecutionException("The remoteServerId is missing in the plugin configuration.");
        }
        if (url == null) {
            throw new MojoExecutionException("The remoteServerUrl is missing in the plugin configuration.");
        }
        this.getLog().debug((CharSequence)("The site will be deployed to '" + url + "' with id '" + id + "'"));
        Repository repository = new Repository(id, url);
        try {
            wagon = this.wagonManager.getWagon(repository);
            UpdateSiteDeployMojo.configureWagon(wagon, repository.getId(), this.settings, this.container, this.getLog());
        }
        catch (UnsupportedProtocolException e) {
            throw new MojoExecutionException("Unsupported protocol: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        catch (WagonConfigurationException e) {
            throw new MojoExecutionException("Unable to configure Wagon: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        if (!wagon.supportsDirectoryCopy()) {
            throw new MojoExecutionException("Wagon protocol '" + repository.getProtocol() + "' doesn't support directory copying");
        }
        try {
            Debug debug = new Debug();
            wagon.addSessionListener((SessionListener)debug);
            wagon.addTransferListener((TransferListener)debug);
            ProxyInfo proxyInfo = UpdateSiteDeployMojo.getProxyInfo(repository, this.wagonManager);
            if (proxyInfo != null) {
                wagon.connect(repository, this.wagonManager.getAuthenticationInfo(id), proxyInfo);
            } else {
                wagon.connect(repository, this.wagonManager.getAuthenticationInfo(id));
            }
            SimpleDateFormat format = new SimpleDateFormat(this.oldBuildDateFormat);
            String postfix = "-" + format.format(new Date());
            if (wagon instanceof CommandExecutor) {
                CommandExecutor exec = (CommandExecutor)wagon;
                String repositoryBasedir = repository.getBasedir();
                String fromDir = repositoryBasedir + "/" + this.remoteDirectory;
                String newDir = repositoryBasedir + "/" + this.remoteDirectory + postfix;
                if (this.moveOldDirectory) {
                    this.getLog().info((CharSequence)("Moving the current update site from: " + fromDir + " to: " + newDir));
                    if (this.mvOptions == null) {
                        this.mvOptions = "";
                    }
                    exec.executeCommand("mv " + this.mvOptions + " " + fromDir + " " + newDir);
                }
                wagon.putDirectory(this.inputDirectory, this.remoteDirectory);
                if (this.chmod) {
                    exec.executeCommand("chmod " + this.chmodOptions + " " + this.chmodMode + " " + repositoryBasedir);
                }
            } else if (this.moveOldDirectory && this.timestampDirectory) {
                String updateSiteDirectory = this.remoteDirectory + postfix;
                if (this.generateHtaccess) {
                    PrintWriter out = new PrintWriter(new FileWriter(this.htaccessFileName));
                    out.println("RewriteEngine on");
                    out.println();
                    out.println("RewriteRule " + this.remoteDirectory + "/(.*) " + this.remoteDirectory + postfix + "/$1");
                    out.close();
                    this.getLog().info((CharSequence)("Created .htaccess file " + this.htaccessFileName + " which will be uploaded to: " + this.remotehtAccessFile + " on completion"));
                }
                wagon.putDirectory(this.inputDirectory, updateSiteDirectory);
                if (this.generateHtaccess) {
                    this.getLog().info((CharSequence)("Uploading .htaccess file " + this.htaccessFileName + " to: " + this.remotehtAccessFile));
                    File htAccessFile = new File(this.htaccessFileName);
                    wagon.put(htAccessFile, this.remotehtAccessFile);
                }
            } else {
                wagon.putDirectory(this.inputDirectory, this.remoteDirectory);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error uploading site", e);
        }
        finally {
            try {
                wagon.disconnect();
            }
            catch (ConnectionException e) {
                this.getLog().error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
            }
        }
    }

    public static ProxyInfo getProxyInfo(Repository repository, WagonManager wagonManager) {
        ProxyInfo proxyInfo = wagonManager.getProxy(repository.getProtocol());
        if (proxyInfo == null) {
            return null;
        }
        String host = repository.getHost();
        String nonProxyHostsAsString = proxyInfo.getNonProxyHosts();
        String[] nonProxyHosts = StringUtils.split((String)nonProxyHostsAsString, (String)",;|");
        for (int i = 0; i < nonProxyHosts.length; ++i) {
            String nonProxyHost = nonProxyHosts[i];
            if (StringUtils.contains((String)nonProxyHost, (String)"*")) {
                String nonProxyHostPrefix = StringUtils.substringBefore((String)nonProxyHost, (String)"*");
                String nonProxyHostSuffix = StringUtils.substringAfter((String)nonProxyHost, (String)"*");
                if (StringUtils.isNotEmpty((String)nonProxyHostPrefix) && host.startsWith(nonProxyHostPrefix) && StringUtils.isEmpty((String)nonProxyHostSuffix)) {
                    return null;
                }
                if (StringUtils.isEmpty((String)nonProxyHostPrefix) && StringUtils.isNotEmpty((String)nonProxyHostSuffix) && host.endsWith(nonProxyHostSuffix)) {
                    return null;
                }
                if (!StringUtils.isNotEmpty((String)nonProxyHostPrefix) || !host.startsWith(nonProxyHostPrefix) || !StringUtils.isNotEmpty((String)nonProxyHostSuffix) || !host.endsWith(nonProxyHostSuffix)) continue;
                return null;
            }
            if (!host.equals(nonProxyHost)) continue;
            return null;
        }
        return proxyInfo;
    }

    static void configureWagon(Wagon wagon, String repositoryId, Settings settings, PlexusContainer container, Log log) throws WagonConfigurationException {
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

