/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.domain;

import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleDescriptor;
import de.smartics.maven.plugin.jboss.modules.domain.ModuleMap;
import de.smartics.maven.plugin.jboss.modules.domain.SlotStrategy;
import de.smartics.maven.plugin.jboss.modules.domain.TransitiveDependencyResolver;
import de.smartics.util.lang.Arg;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.DependencyResolutionException;

public final class ExecutionContext {
    private final Log log;
    private final File targetFolder;
    private final TransitiveDependencyResolver resolver;
    private final SlotStrategy slotStrategy;
    private final String defaultSlot;
    private final ModuleMap moduleMap;

    private ExecutionContext(Builder builder) {
        this.log = builder.log;
        this.targetFolder = builder.targetFolder;
        this.resolver = builder.resolver;
        this.slotStrategy = builder.slotStrategy;
        this.defaultSlot = builder.defaultSlot;
        this.moduleMap = builder.moduleMap;
    }

    public Log getLog() {
        return this.log;
    }

    public File getTargetFolder() {
        return this.targetFolder;
    }

    public TransitiveDependencyResolver getResolver() {
        return this.resolver;
    }

    public SlotStrategy getSlotStrategy() {
        return this.slotStrategy;
    }

    public String getDefaultSlot() {
        return this.defaultSlot;
    }

    public ModuleMap getModuleMap() {
        return this.moduleMap;
    }

    public List<Dependency> resolve(Dependency dependency) {
        try {
            return this.resolver.resolveDirect(dependency);
        }
        catch (DependencyResolutionException e) {
            this.log.error((CharSequence)("Cannot resolve dependency '" + dependency.getArtifact().getArtifactId() + "': " + e.getMessage()));
            return Collections.emptyList();
        }
    }

    public ModuleDescriptor getModule(Dependency dependency) throws IllegalArgumentException {
        ModuleDescriptor module = this.moduleMap.getModule(dependency);
        if (module == null) {
            throw new IllegalArgumentException("Cannot find module for dependency: " + dependency);
        }
        return module;
    }

    public static final class Builder {
        private Log log;
        private File targetFolder;
        private TransitiveDependencyResolver resolver;
        private SlotStrategy slotStrategy;
        private String defaultSlot;
        private ModuleMap moduleMap;

        public Builder with(Log log) {
            this.log = log;
            return this;
        }

        public Builder withTargetFolder(File targetFolder) {
            this.targetFolder = targetFolder;
            return this;
        }

        public Builder with(TransitiveDependencyResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        public Builder with(SlotStrategy slotStrategy) {
            this.slotStrategy = slotStrategy;
            return this;
        }

        public Builder withDefaultSlot(String defaultSlot) {
            this.defaultSlot = defaultSlot;
            return this;
        }

        public Builder with(ModuleMap moduleMap) {
            this.moduleMap = moduleMap;
            return this;
        }

        public ExecutionContext build() throws NullPointerException {
            Arg.checkNotNull((String)"targetFolder", (Object)this.targetFolder);
            Arg.checkNotNull((String)"resolver", (Object)this.resolver);
            Arg.checkNotNull((String)"slotStrategy", (Object)((Object)this.slotStrategy));
            Arg.checkNotNull((String)"moduleMap", (Object)this.moduleMap);
            return new ExecutionContext(this);
        }
    }
}

