/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules;

import de.smartics.maven.plugin.jboss.modules.aether.Mapper;
import de.smartics.maven.plugin.jboss.modules.aether.MavenRepository;
import de.smartics.maven.plugin.jboss.modules.aether.MojoRepositoryBuilder;
import de.smartics.maven.plugin.jboss.modules.aether.filter.DefaultTransitiveDependencyResolver;
import de.smartics.maven.plugin.jboss.modules.aether.filter.ExclusionFilter;
import de.smartics.maven.plugin.jboss.modules.aether.filter.GaExclusionFilter;
import de.smartics.maven.plugin.jboss.modules.aether.filter.TestScopeFilter;
import de.smartics.maven.plugin.jboss.modules.descriptor.ArtifactClusion;
import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleDescriptor;
import de.smartics.maven.plugin.jboss.modules.descriptor.ModulesDescriptor;
import de.smartics.maven.plugin.jboss.modules.domain.ExecutionContext;
import de.smartics.maven.plugin.jboss.modules.domain.ModuleBuilder;
import de.smartics.maven.plugin.jboss.modules.domain.ModuleMap;
import de.smartics.maven.plugin.jboss.modules.domain.PrunerGenerator;
import de.smartics.maven.plugin.jboss.modules.domain.SlotStrategy;
import de.smartics.maven.plugin.jboss.modules.domain.TransitiveDependencyResolver;
import de.smartics.maven.plugin.jboss.modules.parser.ModulesXmlLocator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;

@Mojo(name="create-modules-archive", threadSafe=true, requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE)
public final class JBossModulesArchiveMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Component
    private MavenSession session;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repositorySession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}")
    private List<RemoteRepository> remoteRepos;
    @Component
    private MavenProjectHelper projectHelper;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter
    private final MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="smartics-jboss-modules.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="smartics-jboss-modules.verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="true")
    private boolean attach;
    @Parameter(defaultValue="${offline}")
    private boolean offline;
    @Parameter(property="smartics-jboss-modules.update", defaultValue="never")
    private String updatePolicy;
    @Parameter(property="smartics-jboss-modules.followOptionalDependencies", defaultValue="false")
    private boolean followOptionalDependencies;
    @Parameter(defaultValue="false")
    private boolean ignoreDependencyExclusions;
    @Parameter(defaultValue="main")
    private String defaultSlot;
    @Parameter(defaultValue="main")
    private String slotStrategy;
    @Parameter
    private List<ArtifactClusion> dependencyExcludes;
    @Parameter
    private List<String> modules;
    @Parameter(defaultValue="${project.build.directory}/jboss-modules")
    private File targetFolder;
    @Parameter(defaultValue="${project.build.directory}/${project.artifactId}-${project.version}-jboss-modules.jar")
    private File modulesArchive;
    private List<ModulesDescriptor> modulesDescriptors;
    private List<ModuleDescriptor> allModules;
    @Parameter(defaultValue="false")
    private boolean excludeDependencyManagementDependenciesInPomProject;
    @Parameter(defaultValue="false")
    private boolean ignoreOptionalDependencies;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Skipping creating archive for JBoss modules since skip='true'.");
            return;
        }
        this.modulesDescriptors = this.initModulesDescriptors();
        this.allModules = this.initModules();
        this.repositorySession = this.adjustSession();
        List<Dependency> rootDependencies = this.calcRootDependencies();
        List<Dependency> dependencies = this.resolve(rootDependencies);
        this.logDependencies(rootDependencies, dependencies);
        this.runModuleCreation(dependencies);
        this.attach();
    }

    private List<ModuleDescriptor> initModules() {
        ArrayList<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>();
        for (ModulesDescriptor descriptor : this.modulesDescriptors) {
            modules.addAll(descriptor.getDescriptors());
        }
        return modules;
    }

    private List<ModulesDescriptor> initModulesDescriptors() throws MojoExecutionException {
        try {
            ModulesXmlLocator locator = new ModulesXmlLocator(this.defaultSlot);
            ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
            List<File> rootDirectories = this.calcModulesRootDirectories();
            List<ModulesDescriptor> descriptors = locator.discover(parentClassLoader, rootDirectories);
            return descriptors;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read modules from class path.", (Exception)e);
        }
    }

    private List<File> calcModulesRootDirectories() {
        if (this.modules == null) {
            this.addDefaultDirIfExists("src/etc/jboss-modules");
            this.addDefaultDirIfExists("src/main/config/jboss-modules");
            this.addDefaultDirIfExists("src/main/resources/META-INF/jboss-modules");
        }
        if (this.modules != null) {
            ArrayList<File> rootDirectories = new ArrayList<File>(this.modules.size());
            for (String dir : this.modules) {
                File rootDirectory = new File(this.project.getBasedir(), dir);
                if (rootDirectory.isDirectory()) {
                    rootDirectories.add(rootDirectory);
                    continue;
                }
                this.getLog().warn((CharSequence)String.format("Modules directory '%s' does not exist. Skipping ...", rootDirectory.getAbsolutePath()));
            }
            return rootDirectories;
        }
        return new ArrayList<File>(0);
    }

    private void addDefaultDirIfExists(String defaultDir) {
        File rootDirectory;
        if (this.modules == null) {
            this.modules = new ArrayList<String>(2);
        }
        if ((rootDirectory = new File(this.project.getBasedir(), defaultDir)).isDirectory()) {
            this.modules.add(defaultDir);
        }
    }

    private void runModuleCreation(List<Dependency> dependencies) throws MojoExecutionException {
        boolean isPomProject = "pom".equals(this.project.getPackaging());
        if (!isPomProject || this.excludeDependencyManagementDependenciesInPomProject) {
            Mapper mapper = new Mapper();
            Artifact projectArtifact = mapper.map(this.project.getArtifact());
            Dependency projectAsDependency = new Dependency(projectArtifact, "compile");
            dependencies.add(0, projectAsDependency);
        }
        ExecutionContext context = this.createContext(dependencies);
        for (Map.Entry<ModuleDescriptor, List<Dependency>> entry : context.getModuleMap().toMap().entrySet()) {
            ModuleDescriptor module = entry.getKey();
            HashSet<Dependency> moduleDependencies = new HashSet<Dependency>((Collection)entry.getValue());
            ModuleBuilder builder = new ModuleBuilder(context, module, moduleDependencies);
            try {
                builder.create();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write module '" + entry.getKey().getName() + "'.", (Exception)e);
            }
        }
    }

    private void logDependencies(Collection<Dependency> rootDependencies, Collection<Dependency> dependencies) throws MojoExecutionException {
        if (this.verbose) {
            try {
                FileUtils.writeStringToFile((File)new File(this.project.getBasedir(), "target/root-dependencies.txt"), (String)rootDependencies.toString());
                FileUtils.writeStringToFile((File)new File(this.project.getBasedir(), "target/resolved-dependencies.txt"), (String)dependencies.toString());
            }
            catch (IOException e) {
                throw new MojoExecutionException("dependencies", (Exception)e);
            }
        }
    }

    private DefaultRepositorySystemSession adjustSession() {
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(this.repositorySession);
        HashSet<Object> selectors = new HashSet<Object>();
        selectors.add(new ScopeDependencySelector(new String[]{"test"}));
        if (!this.followOptionalDependencies) {
            selectors.add(new OptionalDependencySelector());
        }
        selectors.add(new ExclusionDependencySelector());
        AndDependencySelector selector = new AndDependencySelector(selectors);
        session.setDependencySelector((DependencySelector)selector);
        session.setUpdatePolicy(this.updatePolicy);
        session.setOffline(this.offline);
        return session;
    }

    private void attach() throws MojoExecutionException {
        if (!this.attach) {
            return;
        }
        if (!this.targetFolder.isDirectory()) {
            this.getLog().info((CharSequence)"Nothing to attach.");
            return;
        }
        try {
            this.jarArchiver.addDirectory(this.targetFolder);
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            archiver.setOutputFile(this.modulesArchive);
            archiver.createArchive(this.session, this.project, this.archive);
            this.projectHelper.attachArtifact(this.project, "jar", "jboss-modules", this.modulesArchive);
        }
        catch (Exception e) {
            String message = String.format("Cannot create archive '%s'.: %s", this.modulesArchive.getAbsolutePath(), e.getMessage());
            throw new MojoExecutionException(message, e);
        }
    }

    private ExecutionContext createContext(List<Dependency> dependencies) {
        ExecutionContext.Builder builder = new ExecutionContext.Builder();
        builder.with(this.getLog());
        builder.withTargetFolder(this.targetFolder);
        TransitiveDependencyResolver resolver = this.createResolver(dependencies);
        builder.with(resolver);
        SlotStrategy slotStrategy = SlotStrategy.fromString(this.slotStrategy);
        builder.with(slotStrategy);
        builder.withDefaultSlot(this.defaultSlot);
        ModuleMap moduleMap = new ModuleMap(this.allModules, dependencies);
        builder.with(moduleMap);
        builder.with(this.ignoreOptionalDependencies);
        if (this.verbose) {
            this.getLog().info((CharSequence)("Modules:\n" + moduleMap.toString()));
        }
        return builder.build();
    }

    private List<Dependency> calcRootDependencies() throws MojoExecutionException {
        DependencyManagement management;
        ArrayList<Dependency> rootDependencies = new ArrayList<Dependency>();
        List projectDependencies = this.project.getDependencies();
        JBossModulesArchiveMojo.addMappedDependencies(rootDependencies, projectDependencies);
        boolean isPomProject = "pom".equals(this.project.getPackaging());
        if (isPomProject && !this.excludeDependencyManagementDependenciesInPomProject && (management = this.project.getDependencyManagement()) != null) {
            List managedDependencies = management.getDependencies();
            JBossModulesArchiveMojo.addMappedDependencies(rootDependencies, managedDependencies);
        }
        return rootDependencies;
    }

    private static void addMappedDependencies(List<Dependency> rootDependencies, List<org.apache.maven.model.Dependency> newDependencies) {
        if (newDependencies != null && !newDependencies.isEmpty()) {
            Mapper mapper = new Mapper();
            for (org.apache.maven.model.Dependency mavenDependency : newDependencies) {
                Dependency dependency = mapper.map(mavenDependency);
                rootDependencies.add(dependency);
            }
        }
    }

    private List<Dependency> resolve(List<Dependency> rootDependencies) throws MojoExecutionException {
        TransitiveDependencyResolver resolver = this.createResolver(null);
        try {
            List<Dependency> dependencies = resolver.resolve(rootDependencies);
            return dependencies;
        }
        catch (DependencyResolutionException e) {
            String message = "Cannot resolve dependency: " + e.getMessage() + "\nYou may use 'dependencyExcludes' to exclude broken dependencies from examination.";
            throw new MojoExecutionException(message, (Exception)((Object)e));
        }
    }

    private TransitiveDependencyResolver createResolver(List<Dependency> managedDependencies) {
        PrunerGenerator prunerGenerator = new PrunerGenerator(this.dependencyExcludes, this.allModules, this.ignoreDependencyExclusions);
        List<DependencyFilter> dependencyFilters = this.createDependencyFilters();
        MojoRepositoryBuilder builder = new MojoRepositoryBuilder();
        builder.with(this.repositorySystem).with(this.repositorySession).with(this.remoteRepos).withDependencyFilters(dependencyFilters).withManagedDependencies(managedDependencies).withOffline(this.offline).withTraverserGenerator(prunerGenerator).build();
        MavenRepository repository = builder.build();
        return new DefaultTransitiveDependencyResolver(repository);
    }

    private List<DependencyFilter> createDependencyFilters() {
        ArrayList<DependencyFilter> dependencyFilters = new ArrayList<DependencyFilter>();
        dependencyFilters.add(TestScopeFilter.INSTANCE);
        if (!this.ignoreDependencyExclusions) {
            dependencyFilters.add(ExclusionFilter.INSTANCE);
        }
        if (this.dependencyExcludes != null && !this.dependencyExcludes.isEmpty()) {
            GaExclusionFilter filter = new GaExclusionFilter(this.dependencyExcludes);
            dependencyFilters.add(filter);
        }
        return dependencyFilters;
    }
}

