/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.aether.filter;

import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;

public final class ExclusionFilter
implements DependencyFilter {
    public static final ExclusionFilter INSTANCE = new ExclusionFilter();

    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return false;
        }
        if (parents.isEmpty()) {
            return true;
        }
        Artifact artifact = dependency.getArtifact();
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        DependencyNode parent = parents.get(0);
        Dependency parentDependency = parent.getDependency();
        if (parentDependency != null) {
            for (Exclusion exclusion : parentDependency.getExclusions()) {
                if (!artifactId.equals(exclusion.getArtifactId()) || !groupId.equals(exclusion.getGroupId())) continue;
                return false;
            }
        }
        return true;
    }
}

