/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.aether.filter;

import de.smartics.maven.plugin.jboss.modules.aether.filter.DependencyFlagger;
import de.smartics.maven.plugin.jboss.modules.descriptor.ArtifactClusion;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;

public final class GaExclusionFilter
implements DependencyFilter {
    private final List<ArtifactClusion> exclusions;

    public GaExclusionFilter(List<ArtifactClusion> exclusions) {
        this.exclusions = exclusions;
    }

    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return false;
        }
        Artifact artifact = dependency.getArtifact();
        for (ArtifactClusion exclusion : this.exclusions) {
            boolean exclude = exclusion.matches(artifact).isMatched();
            if (!exclude) continue;
            DependencyFlagger.INSTANCE.flag(node);
            return false;
        }
        return true;
    }
}

