/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules;

import de.smartics.maven.plugin.jboss.modules.FileSet;
import de.smartics.maven.plugin.jboss.modules.index.Indexer;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="index", threadSafe=true, requiresProject=true, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class IndexMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File outputDirectory;
    @Parameter
    private List<FileSet> fileSets;
    @Parameter(property="smartics-index.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="smartics-index.verbose", defaultValue="false")
    private boolean verbose;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Skipping creating index since skip='true'.");
            return;
        }
        this.runIndexing();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void runIndexing() throws MojoExecutionException {
        Indexer indexer = new Indexer(this.outputDirectory);
        if (this.fileSets == null || this.fileSets.isEmpty()) {
            if (!this.outputDirectory.exists()) {
                this.getLog().info((CharSequence)String.format("Skipping generation of index since no output directory found: %s", this.outputDirectory.getAbsolutePath()));
                return;
            }
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.outputDirectory);
            this.runIndexing(indexer, scanner);
        } else {
            this.runIndexing(indexer);
        }
        indexer.writeIndex();
    }

    private void runIndexing(Indexer indexer) {
        for (FileSet fileSet : this.fileSets) {
            List excludes;
            DirectoryScanner scanner = new DirectoryScanner();
            File baseDir = this.calcBasedir(fileSet);
            scanner.setBasedir(baseDir);
            List includes = fileSet.getIncludes();
            if (includes != null && !includes.isEmpty()) {
                scanner.setIncludes(includes.toArray(new String[includes.size()]));
            }
            if ((excludes = fileSet.getExcludes()) != null && !excludes.isEmpty()) {
                scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
            }
            this.runIndexing(indexer, scanner);
        }
    }

    private File calcBasedir(FileSet fileSet) {
        String directory = fileSet.getDirectory();
        if (StringUtils.isBlank((String)directory)) {
            return this.outputDirectory;
        }
        return new File(directory);
    }

    private void runIndexing(Indexer indexer, DirectoryScanner scanner) {
        scanner.scan();
        for (String dirName : scanner.getIncludedDirectories()) {
            indexer.add(dirName);
            if (!this.verbose) continue;
            this.getLog().info((CharSequence)String.format("Added directory %s.", dirName));
        }
    }
}

