/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.xml;

import de.smartics.maven.plugin.jboss.modules.descriptor.ApplyToDependencies;
import de.smartics.maven.plugin.jboss.modules.descriptor.ApplyToModule;
import de.smartics.maven.plugin.jboss.modules.descriptor.DependenciesDescriptor;
import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleDescriptor;
import de.smartics.maven.plugin.jboss.modules.domain.ExecutionContext;
import de.smartics.maven.plugin.jboss.modules.domain.SlotStrategy;
import de.smartics.maven.plugin.jboss.modules.xml.XmlFragmentParser;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public final class ModuleXmlBuilder {
    public static final Namespace NS = Namespace.getNamespace((String)"urn:jboss:module:1.1");
    private final ExecutionContext context;
    private final ModuleDescriptor module;
    private final Collection<Dependency> dependencies;
    private final Document document;
    private final Element root;
    private final XmlFragmentParser xmlFragmentParser = new XmlFragmentParser();

    public ModuleXmlBuilder(ExecutionContext context, ModuleDescriptor module, Collection<Dependency> dependencies) {
        this.context = context;
        this.module = module;
        this.dependencies = dependencies;
        this.root = new Element("module", NS);
        this.root.setAttribute("name", module.getName());
        String slot = ModuleXmlBuilder.calcSlot(context, module, dependencies);
        if (!"main".equals(slot)) {
            this.root.setAttribute("slot", slot);
        }
        this.document = new Document(this.root);
    }

    private static String calcSlot(ExecutionContext context, ModuleDescriptor module, Collection<Dependency> dependencies) {
        SlotStrategy strategy = context.getSlotStrategy();
        String moduleSlot = module.getSlot();
        String defaultSlot = context.getDefaultSlot();
        Artifact artifact = ModuleXmlBuilder.calcArtifact(dependencies);
        String slot = strategy.calcSlot(defaultSlot, moduleSlot, artifact);
        return slot;
    }

    private static Artifact calcArtifact(Collection<Dependency> dependencies) {
        if (dependencies != null && !dependencies.isEmpty()) {
            Dependency dependency = dependencies.iterator().next();
            Artifact artifact = dependency.getArtifact();
            return artifact;
        }
        return null;
    }

    public Document build() {
        this.addMainClass(this.module);
        this.addProperties(this.module);
        this.addResources(this.module, this.dependencies);
        this.addDependencies(this.module, this.dependencies);
        this.addExports(this.module);
        return this.document;
    }

    private void addMainClass(ModuleDescriptor module) {
        String xml = module.getApplyToModule().getMainClassXml();
        if (xml != null) {
            Element element = this.xmlFragmentParser.parse(xml);
            this.root.addContent((Content)element);
        }
    }

    private void addProperties(ModuleDescriptor module) {
        List<String> xmls = module.getApplyToModule().getPropertiesXml();
        if (xmls.isEmpty()) {
            return;
        }
        Element propertiesElement = new Element("properties", NS);
        for (String xml : xmls) {
            Element element = this.xmlFragmentParser.parse(xml);
            propertiesElement.addContent((Content)element);
        }
        this.root.addContent((Content)propertiesElement);
    }

    private void addResources(ModuleDescriptor module, Collection<Dependency> dependencies) {
        Element resources = new Element("resources", NS);
        List<String> resourceRootsXml = module.getApplyToModule().getResourceRootsXml();
        for (String xml : resourceRootsXml) {
            Element element = this.xmlFragmentParser.parse(xml);
            resources.addContent((Content)element);
        }
        if (!dependencies.isEmpty()) {
            List<SortElement> sorted = this.createSortedResources(dependencies);
            for (SortElement sortElement : sorted) {
                Element resource = new Element("resource-root", NS);
                String fileName = sortElement.key;
                resource.setAttribute("path", fileName);
                resources.addContent((Content)resource);
            }
        }
        if (!resources.getChildren().isEmpty()) {
            this.root.addContent((Content)resources);
        }
    }

    private List<SortElement> createSortedResources(Collection<Dependency> dependencies) {
        ArrayList<SortElement> sorted = new ArrayList<SortElement>(dependencies.size());
        for (Dependency dependency : dependencies) {
            Artifact artifact = dependency.getArtifact();
            File file = artifact.getFile();
            if (file == null) continue;
            String fileName = file.getName();
            sorted.add(new SortElement(fileName, dependency));
        }
        Collections.sort(sorted);
        return sorted;
    }

    private void addDependencies(ModuleDescriptor module, Collection<Dependency> dependencies) {
        ApplyToModule applyToModule = module.getApplyToModule();
        List<String> staticDependencies = applyToModule.getDependenciesXml();
        if (!dependencies.isEmpty() || !staticDependencies.isEmpty()) {
            Element dependenciesElement = new Element("dependencies", NS);
            this.addStaticDependencies(staticDependencies, dependenciesElement);
            this.addResolvedDependencies(module, dependencies, dependenciesElement);
            this.root.addContent((Content)dependenciesElement);
        }
    }

    private void addResolvedDependencies(ModuleDescriptor module, Collection<Dependency> dependencies, Element dependenciesElement) {
        Set<SortElement> sorted = this.createSortedDependencies(module, dependencies);
        ApplyToDependencies apply = module.getApplyToDependencies();
        for (SortElement element : sorted) {
            String name = element.key;
            Element moduleElement = new Element("module", NS);
            moduleElement.setAttribute("name", name);
            DependenciesDescriptor dd = apply.getDescriptorThatMatches(name);
            if (!this.isIncludableDependency(element, dd)) continue;
            this.handleOptional(element, moduleElement, dd);
            this.handleExport(moduleElement, dd);
            this.handleServices(moduleElement, dd);
            this.handleSlot(module, element, moduleElement);
            dependenciesElement.addContent((Content)moduleElement);
        }
    }

    private boolean isIncludableDependency(SortElement element, DependenciesDescriptor dd) {
        boolean isOptional;
        boolean isSkipped = dd.getSkip() != null && dd.getSkip() == true;
        boolean bl = isOptional = dd.getOptional() != null && dd.getOptional() == true || element.dependency.isOptional();
        if (isSkipped) {
            return false;
        }
        return !isOptional || this.context.isIgnoreOptionalDependencies() == false;
    }

    private void handleOptional(SortElement element, Element moduleElement, DependenciesDescriptor dd) {
        Boolean ddOptional = dd.getOptional();
        if (ddOptional != null && ddOptional.booleanValue() || ddOptional == null || element.dependency.isOptional()) {
            moduleElement.setAttribute("optional", "true");
        }
    }

    private void handleExport(Element moduleElement, DependenciesDescriptor dd) {
        Boolean ddExport = dd.getExport();
        if (ddExport != null && ddExport.booleanValue()) {
            moduleElement.setAttribute("export", "true");
        }
    }

    private void handleServices(Element moduleElement, DependenciesDescriptor dd) {
        String services = dd.getServices();
        if (services != null && !"none".equals(services)) {
            moduleElement.setAttribute("services", services);
        }
    }

    private void handleSlot(ModuleDescriptor module, SortElement element, Element moduleElement) {
        SlotStrategy slotStrategy = this.context.getSlotStrategy();
        Dependency dependency = element.dependency;
        String defaultSlot = this.calcDefaultSlot(module, dependency);
        String slot = slotStrategy.calcSlot(dependency.getArtifact(), defaultSlot);
        if (!"main".equals(slot)) {
            moduleElement.setAttribute("slot", slot);
        }
    }

    private Set<SortElement> createSortedDependencies(ModuleDescriptor module, Collection<Dependency> dependencies) {
        TreeSet<SortElement> sorted = new TreeSet<SortElement>();
        for (Dependency dependency : dependencies) {
            List<Dependency> resolvedDependencies = this.context.resolve(dependency);
            this.addSortedDependencies(sorted, module, resolvedDependencies);
        }
        return sorted;
    }

    private String calcDefaultSlot(ModuleDescriptor module, Dependency dependency) {
        String moduleSlot;
        ModuleDescriptor depModule = this.context.getModule(dependency);
        String depModuleSlot = depModule.getSlot();
        if (StringUtils.isNotBlank((String)depModuleSlot)) {
            return depModuleSlot;
        }
        boolean inheritSlot = module.getDirectives().getInheritSlot();
        if (inheritSlot && StringUtils.isNotBlank((String)(moduleSlot = module.getSlot()))) {
            return moduleSlot;
        }
        String defaultSlot = this.context.getDefaultSlot();
        return defaultSlot;
    }

    private void addStaticDependencies(List<String> staticDependencies, Element dependenciesElement) {
        if (!staticDependencies.isEmpty()) {
            for (String xml : staticDependencies) {
                Element element = this.xmlFragmentParser.parse(xml);
                dependenciesElement.addContent((Content)element);
            }
        }
    }

    private void addSortedDependencies(Set<SortElement> sorted, ModuleDescriptor owningModule, List<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            try {
                ModuleDescriptor module = this.context.getModule(dependency);
                String name = module.getName();
                if (name.equals(owningModule.getName())) continue;
                SortElement e = new SortElement(name, dependency);
                if (sorted.contains(e)) {
                    for (SortElement current : sorted) {
                        if (!current.equals(e) || !current.dependency.isOptional() || dependency.isOptional()) continue;
                        sorted.remove(current);
                        break;
                    }
                }
                sorted.add(e);
            }
            catch (IllegalArgumentException e) {
                this.context.getLog().error((CharSequence)String.format("Skipping '%s' referenced from module '%s'.", dependency.getArtifact().getArtifactId(), owningModule.getName()));
            }
        }
    }

    private void addExports(ModuleDescriptor module2) {
        String xml = this.module.getApplyToModule().getExportsXml();
        if (xml != null) {
            Element element = this.xmlFragmentParser.parse(xml);
            this.root.addContent((Content)element);
        }
    }

    private static final class SortElement
    implements Comparable<SortElement> {
        private final String key;
        private final Dependency dependency;

        private SortElement(String key, Dependency dependency) {
            this.key = key;
            this.dependency = dependency;
        }

        public int hashCode() {
            return ObjectUtils.hashCode((Object)this.key);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SortElement other = (SortElement)object;
            return ObjectUtils.equals((Object)this.key, (Object)other.key);
        }

        @Override
        public int compareTo(SortElement o) {
            return this.key.compareTo(o.key);
        }

        public String toString() {
            return String.valueOf(this.key) + ": " + String.valueOf(this.dependency);
        }
    }
}

