/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.aether;

import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepositoryLogListener
extends AbstractRepositoryListener {
    private final Logger log;

    public RepositoryLogListener() {
        this(LoggerFactory.getLogger(RepositoryLogListener.class));
    }

    public RepositoryLogListener(Logger log) {
        this.log = log;
    }

    public void artifactDescriptorMissing(RepositoryEvent event) {
        this.log.warn("Missing descriptor for artifact '{}'.", (Object)event.getArtifact());
    }

    public void artifactDescriptorInvalid(RepositoryEvent event) {
        this.log.warn("Invalid descriptor for artifact '{}': {}", (Object)event.getArtifact(), (Object)event.getException().getMessage());
    }

    public void metadataInvalid(RepositoryEvent event) {
        this.log.warn("Invalid metadata: {}", (Object)event.getMetadata());
    }

    public void metadataResolving(RepositoryEvent event) {
        this.log.debug("Resolving metadata '{}' from '{}'.", (Object)event.getMetadata(), (Object)event.getRepository());
    }

    public void metadataResolved(RepositoryEvent event) {
        this.log.debug("Resolved metadata '{}' from '{}'.", (Object)event.getMetadata(), (Object)event.getRepository());
    }

    public void artifactResolving(RepositoryEvent event) {
        this.log.debug("Resolving artifact '{}'." + event.getArtifact());
    }

    public void artifactResolved(RepositoryEvent event) {
        this.log.debug("Resolved artifact '{}' from '{}'.", (Object)event.getArtifact(), (Object)event.getRepository());
    }

    public void artifactDownloading(RepositoryEvent event) {
        this.log.debug("Downloading artifact '{}' from '{}'.", (Object)event.getArtifact(), (Object)event.getRepository());
    }

    public void artifactDownloaded(RepositoryEvent event) {
        this.log.debug("Downloaded artifact '{}' from '{}'.", (Object)event.getArtifact(), (Object)event.getRepository());
    }
}

