/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.descriptor;

import de.smartics.maven.plugin.jboss.modules.domain.MatchContext;
import de.smartics.maven.plugin.jboss.modules.domain.matching.DoubleMatchContext;
import de.smartics.maven.plugin.jboss.modules.domain.matching.SingleMatchContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.aether.artifact.Artifact;

public class ArtifactClusion {
    private String groupId;
    private Pattern groupIdPattern;
    private String artifactId;
    private Pattern artifactIdPattern;

    public static ArtifactClusion create(String groupId, String artifactId) {
        ArtifactClusion clusion = new ArtifactClusion();
        clusion.setGroupId(groupId);
        clusion.setArtifactId(artifactId);
        return clusion;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        if (StringUtils.isNotBlank((String)groupId)) {
            this.groupId = groupId;
            this.groupIdPattern = ArtifactClusion.compilePattern(groupId);
        }
    }

    private static Pattern compilePattern(String pattern) {
        if (StringUtils.isNotBlank((String)pattern)) {
            try {
                return Pattern.compile(pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        if (StringUtils.isNotBlank((String)artifactId)) {
            this.artifactId = artifactId;
            this.artifactIdPattern = ArtifactClusion.compilePattern(artifactId);
        }
    }

    public MatchContext matches(Artifact artifact) {
        SingleMatchContext matchesGroupId = ArtifactClusion.matches(this.groupIdPattern, this.groupId, artifact.getGroupId());
        if (matchesGroupId != null && !matchesGroupId.isMatched()) {
            return new SingleMatchContext(false);
        }
        SingleMatchContext matchesArtifactId = ArtifactClusion.matches(this.artifactIdPattern, this.artifactId, artifact.getArtifactId());
        boolean result = matchesGroupId != null && matchesGroupId.isMatched() && (matchesArtifactId == null || matchesArtifactId.isMatched()) || matchesArtifactId != null && matchesArtifactId.isMatched();
        DoubleMatchContext context = new DoubleMatchContext(result, matchesGroupId, matchesArtifactId);
        return context;
    }

    private static SingleMatchContext matches(Pattern pattern, String id, String inputId) {
        if (pattern != null) {
            Matcher matcher = pattern.matcher(inputId);
            return new SingleMatchContext(matcher);
        }
        if (StringUtils.isNotBlank((String)id)) {
            return new SingleMatchContext(id.equals(inputId));
        }
        return null;
    }

    public String toString() {
        return ObjectUtils.toString((Object)this.groupId) + ':' + ObjectUtils.toString((Object)this.artifactId);
    }
}

