/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.descriptor;

import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleMatcher;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class DependenciesDescriptor {
    private final ModuleMatcher matcher;
    private final String slot;
    private final Boolean skip;
    private final Boolean export;
    private final String services;
    private final Boolean optional;
    private final String importsXml;
    private final String exportsXml;

    private DependenciesDescriptor(Builder builder) {
        this.matcher = builder.matcher;
        this.slot = builder.slot;
        this.skip = builder.skip;
        this.export = builder.export;
        this.services = builder.services;
        this.optional = builder.optional;
        this.importsXml = builder.importsXml;
        this.exportsXml = builder.exportsXml;
    }

    public ModuleMatcher getMatcher() {
        return this.matcher;
    }

    public String getSlot() {
        return this.slot;
    }

    public Boolean getSkip() {
        return this.skip;
    }

    public Boolean getExport() {
        return this.export;
    }

    public String getServices() {
        return this.services;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public String getImportsXml() {
        return this.importsXml;
    }

    public String getExportsXml() {
        return this.exportsXml;
    }

    public boolean matches(String name) {
        return this.matcher.matches(name);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)false, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependenciesDescriptor that = (DependenciesDescriptor)o;
        if (this.slot != null ? !this.slot.equals(that.slot) : that.slot != null) {
            return false;
        }
        if (this.skip != null ? !this.skip.equals(that.skip) : that.skip != null) {
            return false;
        }
        if (this.export != null ? !this.export.equals(that.export) : that.export != null) {
            return false;
        }
        if (this.services != null ? !this.services.equals(that.services) : that.services != null) {
            return false;
        }
        if (this.optional != null ? !this.optional.equals(that.optional) : that.optional != null) {
            return false;
        }
        if (this.importsXml != null ? !this.importsXml.equals(that.importsXml) : that.importsXml != null) {
            return false;
        }
        return !(this.exportsXml == null ? that.exportsXml != null : !this.exportsXml.equals(that.exportsXml));
    }

    public int hashCode() {
        int result = this.slot != null ? this.slot.hashCode() : 0;
        result = 31 * result + (this.skip != null ? this.skip.hashCode() : 0);
        result = 31 * result + (this.export != null ? this.export.hashCode() : 0);
        result = 31 * result + (this.services != null ? this.services.hashCode() : 0);
        result = 31 * result + (this.optional != null ? this.optional.hashCode() : 0);
        result = 31 * result + (this.importsXml != null ? this.importsXml.hashCode() : 0);
        result = 31 * result + (this.exportsXml != null ? this.exportsXml.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private ModuleMatcher matcher;
        private String slot;
        private Boolean skip;
        private Boolean export;
        private String services;
        private Boolean optional;
        private String importsXml;
        private String exportsXml;

        public Builder with(ModuleMatcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public Builder withSlot(String slot) {
            if (StringUtils.isNotBlank((String)slot)) {
                this.slot = slot;
            }
            return this;
        }

        public Builder withSkip(String skip) {
            if (StringUtils.isNotBlank((String)skip)) {
                this.skip = Boolean.parseBoolean(skip);
            }
            return this;
        }

        public Builder withExport(String export) {
            if (StringUtils.isNotBlank((String)export)) {
                this.export = Boolean.parseBoolean(export);
            }
            return this;
        }

        public Builder withServices(String services) {
            if (StringUtils.isNotBlank((String)services)) {
                this.services = services;
            }
            return this;
        }

        public Builder withOptional(String optional) {
            if (StringUtils.isNotBlank((String)optional)) {
                this.optional = Boolean.parseBoolean(optional);
            }
            return this;
        }

        public Builder withImportsXml(String importsXml) {
            this.importsXml = importsXml;
            return this;
        }

        public Builder withExportsXml(String exportsXml) {
            this.exportsXml = exportsXml;
            return this;
        }

        public void merge(String moduleName, DependenciesDescriptor descriptor) {
            this.slot = this.merge("slot", moduleName, this.slot, descriptor.slot);
            this.skip = this.merge("skip", moduleName, this.skip, descriptor.skip);
            this.export = this.merge("export", moduleName, this.export, descriptor.export);
            this.services = this.merge("services", moduleName, this.services, descriptor.services);
            this.optional = this.merge("optional", moduleName, this.optional, descriptor.optional);
            this.importsXml = this.merge("imports", moduleName, this.importsXml, descriptor.importsXml);
            this.exportsXml = this.merge("exports", moduleName, this.exportsXml, descriptor.exportsXml);
        }

        private <T> T merge(String property, String moduleName, T value1, T value2) {
            if (value1 != null && value2 != null && !value1.equals(value2)) {
                throw new IllegalArgumentException(String.format("Module %s: Cannot merge %s: '%s' differs from '%s'.", moduleName, property, value1, value2));
            }
            return value1 == null ? value2 : value1;
        }

        public DependenciesDescriptor build() {
            if (this.matcher == null) {
                this.matcher = new ModuleMatcher.Builder().build();
            }
            if (this.export == null) {
                this.export = Boolean.FALSE;
            }
            if (this.optional == null) {
                this.optional = Boolean.FALSE;
            }
            return new DependenciesDescriptor(this);
        }
    }
}

