/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.descriptor;

import de.smartics.util.lang.Arg;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;

public final class ModuleClusion {
    private final String name;
    private final Pattern namePattern;

    public ModuleClusion(String name) throws IllegalArgumentException {
        this.name = (String)Arg.checkNotBlankExceptNull((String)"name", (CharSequence)name);
        this.namePattern = ModuleClusion.compilePattern(name);
    }

    private static Pattern compilePattern(String pattern) {
        if (StringUtils.isNotBlank((String)pattern)) {
            try {
                return Pattern.compile(pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean match(String moduleName) {
        if (this.name == null) {
            return true;
        }
        if (this.namePattern != null) {
            Matcher matcher = this.namePattern.matcher(moduleName);
            return matcher.matches();
        }
        return this.name.equals(moduleName);
    }

    public String toString() {
        return this.name;
    }
}

