/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.descriptor;

import de.smartics.maven.plugin.jboss.modules.descriptor.ApplyToDependencies;
import de.smartics.maven.plugin.jboss.modules.descriptor.ApplyToModule;
import de.smartics.maven.plugin.jboss.modules.descriptor.ArtifactMatcher;
import de.smartics.maven.plugin.jboss.modules.descriptor.Directives;
import de.smartics.maven.plugin.jboss.modules.domain.MatchContext;
import de.smartics.util.lang.Arg;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.eclipse.aether.artifact.Artifact;

public final class ModuleDescriptor {
    private final String name;
    private String slot;
    private final Directives directives;
    private final ArtifactMatcher matcher;
    private final ApplyToDependencies applyToDependencies;
    private final ApplyToModule applyToModule;

    private ModuleDescriptor(String name, ModuleDescriptor originalModule) {
        this.name = name;
        this.slot = originalModule.slot;
        this.directives = originalModule.directives;
        this.matcher = originalModule.matcher;
        this.applyToDependencies = originalModule.applyToDependencies;
        this.applyToModule = originalModule.applyToModule;
    }

    private ModuleDescriptor(Builder builder) {
        this.name = builder.name;
        this.slot = builder.slot;
        this.directives = builder.directives;
        this.matcher = builder.matcher;
        this.applyToDependencies = builder.applyToDependencies;
        this.applyToModule = builder.applyToModule;
    }

    public static ModuleDescriptor copy(String name, ModuleDescriptor originalModule) {
        return new ModuleDescriptor(name, originalModule);
    }

    public static ModuleDescriptor create(String name) {
        return new Builder().withName(name).build();
    }

    public String getName() {
        return this.name;
    }

    public String getSlot() {
        return this.slot;
    }

    public Directives getDirectives() {
        return this.directives;
    }

    public ArtifactMatcher getMatcher() {
        return this.matcher;
    }

    public ApplyToDependencies getApplyToDependencies() {
        return this.applyToDependencies;
    }

    public ApplyToModule getApplyToModule() {
        return this.applyToModule;
    }

    public void applySlot(String slot) {
        if (this.slot == null) {
            this.slot = slot;
        }
    }

    public MatchContext match(Artifact artifact) {
        return this.matcher.match(artifact);
    }

    public void merge(ModuleDescriptor moduleDescriptor) throws NullPointerException, IllegalArgumentException {
        if (!ObjectUtils.equals((Object)this.name, (Object)moduleDescriptor.name) || !ObjectUtils.equals((Object)this.slot, (Object)moduleDescriptor.slot)) {
            throw new IllegalArgumentException(String.format("Cannot merge different modules: %s:%s vs %s:%s.", this.name, this.slot, moduleDescriptor.name, moduleDescriptor.slot));
        }
        this.directives.merge(moduleDescriptor.directives);
        this.applyToDependencies.merge(moduleDescriptor.applyToDependencies);
        this.applyToModule.merge(moduleDescriptor.applyToModule);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + ObjectUtils.hashCode((Object)this.name);
        result = 37 * result + ObjectUtils.hashCode((Object)this.slot);
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ModuleDescriptor other = (ModuleDescriptor)object;
        return ObjectUtils.equals((Object)this.name, (Object)other.name) && ObjectUtils.equals((Object)this.slot, (Object)other.slot);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)false, null);
    }

    public static final class Builder {
        private String name;
        private String slot;
        private Directives directives;
        private ArtifactMatcher matcher;
        private ApplyToDependencies applyToDependencies;
        private ApplyToModule applyToModule;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withSlot(String slot) {
            this.slot = slot;
            return this;
        }

        public Builder with(Directives directives) {
            this.directives = directives;
            return this;
        }

        public Builder with(ArtifactMatcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public Builder with(ApplyToDependencies applyToDependencies) {
            this.applyToDependencies = applyToDependencies;
            return this;
        }

        public Builder with(ApplyToModule applyToModule) {
            this.applyToModule = applyToModule;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public String getSlot() {
            return this.slot;
        }

        public Directives getDirectives() {
            return this.directives;
        }

        public ArtifactMatcher getMatcher() {
            return this.matcher;
        }

        public ApplyToDependencies getApplyToDependencies() {
            return this.applyToDependencies;
        }

        public ApplyToModule getApplyToModule() {
            return this.applyToModule;
        }

        public ModuleDescriptor build() throws NullPointerException, IllegalArgumentException {
            Arg.checkNotBlank((String)"name", (CharSequence)this.name);
            if (this.directives == null) {
                this.directives = new Directives.Builder().build();
            }
            if (this.matcher == null) {
                this.matcher = new ArtifactMatcher.Builder().build();
            }
            if (this.applyToDependencies == null) {
                this.applyToDependencies = new ApplyToDependencies.Builder().build();
            }
            if (this.applyToModule == null) {
                this.applyToModule = new ApplyToModule.Builder().build();
            }
            return new ModuleDescriptor(this);
        }
    }
}

