/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.domain.matching;

import de.smartics.maven.plugin.jboss.modules.domain.MatchContext;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;

public final class SingleMatchContext
implements MatchContext {
    private final boolean result;
    private final MatchResult matchResult;

    public SingleMatchContext(boolean result) {
        this.result = result;
        this.matchResult = null;
    }

    public SingleMatchContext(Matcher matcher) {
        this.result = matcher.matches();
        this.matchResult = matcher.toMatchResult();
    }

    @Override
    public boolean isMatched() {
        return this.result;
    }

    @Override
    public MatchResult getMatchResult() {
        return this.matchResult;
    }

    @Override
    public String translateName(String input) {
        int groupCount;
        if (this.matchResult != null && this.isMatched() && (groupCount = this.matchResult.groupCount()) > 0) {
            String translation = input;
            for (int group = 1; group <= groupCount; ++group) {
                String replacement = this.matchResult.group(group);
                translation = translation.replace("$" + group, replacement);
            }
            return translation;
        }
        return input;
    }

    @Override
    public boolean hasGroupMatch() {
        if (this.matchResult != null && this.isMatched()) {
            int groupCount = this.matchResult.groupCount();
            return groupCount > 0;
        }
        return false;
    }
}

