/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules;

import de.smartics.maven.plugin.jboss.modules.FileSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;

@Mojo(name="jandex", threadSafe=true, requiresProject=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class JandexMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File outputDirectory;
    @Parameter
    private List<FileSet> fileSets;
    @Parameter(property="smartics-jandex.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="smartics-jandex.verbose", defaultValue="false")
    private boolean verbose;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Skipping creating Jandex since skip='true'.");
            return;
        }
        this.runIndexing();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void runIndexing() throws MojoExecutionException {
        Indexer indexer = new Indexer();
        if (this.fileSets == null || this.fileSets.isEmpty()) {
            if (!this.outputDirectory.exists()) {
                this.getLog().info((CharSequence)String.format("Skipping generation of index since no output directory found: %s", this.outputDirectory.getAbsolutePath()));
                return;
            }
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.outputDirectory);
            this.runIndexing(indexer, scanner);
        } else {
            this.runIndexing(indexer);
        }
        this.writeIndex(indexer);
    }

    private void runIndexing(Indexer indexer) {
        for (FileSet fileSet : this.fileSets) {
            List excludes;
            DirectoryScanner scanner = new DirectoryScanner();
            File baseDir = this.calcBasedir(fileSet);
            scanner.setBasedir(baseDir);
            List includes = fileSet.getIncludes();
            if (includes != null && !includes.isEmpty()) {
                scanner.setIncludes(includes.toArray(new String[includes.size()]));
            }
            if ((excludes = fileSet.getExcludes()) != null && !excludes.isEmpty()) {
                scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
            }
            this.runIndexing(indexer, scanner);
        }
    }

    private File calcBasedir(FileSet fileSet) {
        String directory = fileSet.getDirectory();
        if (StringUtils.isBlank((String)directory)) {
            return this.outputDirectory;
        }
        return new File(directory);
    }

    private void runIndexing(Indexer indexer, DirectoryScanner scanner) {
        scanner.scan();
        for (String fileName : scanner.getIncludedFiles()) {
            if (!fileName.endsWith(".class")) continue;
            File file = new File(scanner.getBasedir(), fileName);
            FileInputStream input = null;
            try {
                input = FileUtils.openInputStream((File)file);
                ClassInfo info = indexer.index((InputStream)input);
                if (!this.verbose) continue;
                this.getLog().info((CharSequence)String.format("Indexed %2d annotations in file %s.", info.annotations().size(), info.name()));
            }
            catch (IOException e) {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
    }

    private void writeIndex(Indexer indexer) throws MojoExecutionException {
        File indexFile = new File(this.outputDirectory, "META-INF/jandex.idx");
        indexFile.getParentFile().mkdirs();
        FileOutputStream indexOutput = null;
        try {
            indexOutput = FileUtils.openOutputStream((File)indexFile);
            IndexWriter writer = new IndexWriter((OutputStream)indexOutput);
            Index index = indexer.complete();
            writer.write(index);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Cannot write index file '%s'.", indexFile.getAbsoluteFile()), (Exception)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)indexOutput);
        }
    }
}

