/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.domain;

import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleDescriptor;
import de.smartics.maven.plugin.jboss.modules.domain.ExecutionContext;
import de.smartics.maven.plugin.jboss.modules.domain.SlotStrategy;
import de.smartics.maven.plugin.jboss.modules.xml.ModuleXmlBuilder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public final class ModuleBuilder {
    private final ExecutionContext context;
    private final ModuleDescriptor module;
    private final List<Dependency> dependencies;

    public ModuleBuilder(ExecutionContext context, ModuleDescriptor module, Collection<Dependency> dependencies) {
        this.context = context;
        this.module = module;
        this.dependencies = new ArrayList<Dependency>(dependencies);
    }

    public void create() throws IOException {
        if (!this.module.getDirectives().getSkip().booleanValue()) {
            File moduleFolder = this.createModuleFolder();
            this.createModuleXml(moduleFolder);
            this.copyResources(moduleFolder);
        }
    }

    private File createModuleFolder() throws IOException {
        String path = this.module.getName().replace('.', '/');
        File folder = new File(this.context.getTargetFolder(), path);
        File slotFolder = new File(folder, this.calcSlot());
        boolean created = slotFolder.mkdirs();
        if (!created) {
            throw new IOException(String.format("Cannot created folder '%s' for module '%s'.", slotFolder.getAbsolutePath(), this.module.getName()));
        }
        return slotFolder;
    }

    private String calcSlot() {
        SlotStrategy strategy = this.context.getSlotStrategy();
        Artifact artifact = this.dependencies.isEmpty() ? null : this.dependencies.get(0).getArtifact();
        String moduleSlot = this.module.getSlot();
        String defaultSlot = this.context.getDefaultSlot();
        String slot = strategy.calcSlot(defaultSlot, moduleSlot, artifact);
        return slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createModuleXml(File moduleFolder) throws IOException {
        ModuleXmlBuilder xml = new ModuleXmlBuilder(this.context, this.module, this.dependencies);
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        File file = new File(moduleFolder, "module.xml");
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            Document document = xml.build();
            outputter.output(document, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private void copyResources(File moduleFolder) throws IOException {
        for (Dependency dependency : this.dependencies) {
            Artifact artifact = dependency.getArtifact();
            File remoteFile = artifact.getFile();
            if (remoteFile != null) {
                File localFile = new File(moduleFolder, remoteFile.getName());
                FileUtils.copyFile((File)remoteFile, (File)localFile);
                continue;
            }
            this.context.getLog().warn((CharSequence)String.format("Cannot copy non-existing remote file for dependency '%s'.", dependency.getArtifact()));
        }
    }
}

