/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import org.fxmisc.wellbehaved.event.EventPattern;

@FunctionalInterface
public interface EventHandlerTemplate<T, E extends Event> {
    public BiConsumer<? super T, ? super E> getHandler();

    default public EventHandler<E> bind(T target) {
        BiConsumer handler = this.getHandler();
        return event -> handler.accept(target, event);
    }

    default public <U extends T, F extends E> EventHandlerTemplate<U, F> orElse(EventHandlerTemplate<U, F> that) {
        return () -> {
            BiConsumer thisHandler = this.getHandler();
            BiConsumer thatHandler = that.getHandler();
            return (u, e) -> {
                thisHandler.accept(u, e);
                if (!e.isConsumed()) {
                    thatHandler.accept(u, e);
                }
            };
        };
    }

    default public <U extends T> EventHandlerTemplate<U, E> onlyWhen(Predicate<? super U> condition) {
        return () -> {
            BiConsumer handler = this.getHandler();
            return (u, e) -> {
                if (condition.test((Object)u)) {
                    handler.accept(u, e);
                }
            };
        };
    }

    default public <U extends T, F extends E> EventHandlerTemplate<U, F> ifConsumed(BiConsumer<? super U, ? super F> postConsumption) {
        return () -> {
            BiConsumer handler = this.getHandler();
            return (u, f) -> {
                handler.accept(u, f);
                if (f.isConsumed()) {
                    postConsumption.accept((Object)u, (Object)f);
                }
            };
        };
    }

    public static <T, E extends Event, F extends E> On<T, E, F> on(EventPattern<? super E, ? extends F> eventMatcher) {
        return Builder.empty().on(eventMatcher);
    }

    public static <T, E extends Event> On<T, Event, E> on(EventType<? extends E> eventType) {
        return Builder.empty().on(eventType);
    }

    public static <T, E extends Event> Builder<T, E> startWith(BiConsumer<? super T, ? super E> handler) {
        return Builder.empty().addHandler(handler);
    }

    public static class When<T, E extends Event, F extends E> {
        private final Builder<? super T, ? super E> previousBuilder;
        private final EventPattern<? super E, ? extends F> eventMatcher;
        private final Predicate<? super T> condition;

        private When(Builder<? super T, ? super E> previousBuilder, EventPattern<? super E, ? extends F> eventMatcher, Predicate<? super T> condition) {
            this.previousBuilder = previousBuilder;
            this.eventMatcher = eventMatcher;
            this.condition = condition;
        }

        public <U extends T> Builder<U, E> act(BiConsumer<? super U, ? super F> action) {
            return this.previousBuilder.addHandler((u, e) -> this.eventMatcher.match(e).ifPresent(f -> {
                if (this.condition.test(u)) {
                    action.accept((Object)u, (F)f);
                    f.consume();
                }
            }));
        }
    }

    public static class On<T, E extends Event, F extends E> {
        private final Builder<? super T, ? super E> previousBuilder;
        private final EventPattern<? super E, ? extends F> eventMatcher;

        private On(Builder<? super T, ? super E> previous, EventPattern<? super E, ? extends F> eventMatcher) {
            this.previousBuilder = previous;
            this.eventMatcher = eventMatcher;
        }

        public On<T, E, F> where(Predicate<? super F> condition) {
            return new On<T, E, F>(this.previousBuilder, this.eventMatcher.and(condition));
        }

        public <U extends T> When<U, E, F> when(Predicate<? super U> condition) {
            return new When(this.previousBuilder, this.eventMatcher, condition);
        }

        public <U extends T> Builder<U, E> act(BiConsumer<? super U, ? super F> action) {
            return this.previousBuilder.addHandler((t, e) -> this.eventMatcher.match(e).ifPresent(f -> {
                action.accept((Object)t, (Object)f);
                f.consume();
            }));
        }
    }

    public static abstract class Builder<T, E extends Event> {
        private static <T, E extends Event> Builder<T, E> empty() {
            return new Builder<T, E>(){

                @Override
                <U extends T, F extends E> List<BiConsumer<? super U, ? super F>> getHandlers(int additionalCapacity) {
                    return new ArrayList<BiConsumer<? super U, ? super F>>(additionalCapacity);
                }
            };
        }

        private Builder() {
        }

        public <F extends E> On<T, E, F> on(EventPattern<? super E, ? extends F> eventMatcher) {
            return new On(this, eventMatcher);
        }

        public <F extends E> On<T, E, F> on(EventType<? extends F> eventType) {
            return this.on(EventPattern.eventTypePattern(eventType));
        }

        public <U extends T, F extends E> Builder<U, F> addHandler(BiConsumer<? super U, ? super F> handler) {
            return new CompositeBuilder(this, handler);
        }

        public EventHandlerTemplate<T, E> create() {
            List handlers = this.getHandlers();
            BiConsumer<Object, Event> handler = (target, event) -> {
                for (BiConsumer h : handlers) {
                    h.accept(target, event);
                    if (!event.isConsumed()) continue;
                    break;
                }
            };
            return () -> handler;
        }

        List<BiConsumer<? super T, ? super E>> getHandlers() {
            return this.getHandlers(0);
        }

        abstract <U extends T, F extends E> List<BiConsumer<? super U, ? super F>> getHandlers(int var1);

        private static class CompositeBuilder<T, E extends Event>
        extends Builder<T, E> {
            private final Builder<? super T, ? super E> previousBuilder;
            private final BiConsumer<? super T, ? super E> handler;

            private CompositeBuilder(Builder<? super T, ? super E> previousBuilder, BiConsumer<? super T, ? super E> handler) {
                this.previousBuilder = previousBuilder;
                this.handler = handler;
            }

            @Override
            <U extends T, F extends E> List<BiConsumer<? super U, ? super F>> getHandlers(int additionalCapacity) {
                List<BiConsumer<U, F>> handlers = this.previousBuilder.getHandlers(additionalCapacity + 1);
                handlers.add(this.handler);
                return handlers;
            }
        }
    }
}

