/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event.experimental;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.fxmisc.wellbehaved.event.experimental.KeyCodePatternCombination;
import org.fxmisc.wellbehaved.event.experimental.KeyTypedCombination;

public interface EventPattern<T extends Event, U extends T> {
    public Optional<? extends U> match(T var1);

    public Set<EventType<? extends U>> getEventTypes();

    default public <V extends U> EventPattern<T, V> andThen(final EventPattern<? super U, V> next) {
        return new EventPattern<T, V>(){

            @Override
            public Optional<? extends V> match(T event) {
                return EventPattern.this.match(event).flatMap(next::match);
            }

            @Override
            public Set<EventType<? extends V>> getEventTypes() {
                return next.getEventTypes();
            }
        };
    }

    default public EventPattern<T, U> onlyIf(final Predicate<? super U> condition) {
        return new EventPattern<T, U>(){

            @Override
            public Optional<U> match(T event) {
                return EventPattern.this.match(event).map(u -> condition.test(u) ? u : null);
            }

            @Override
            public Set<EventType<? extends U>> getEventTypes() {
                return EventPattern.this.getEventTypes();
            }
        };
    }

    default public EventPattern<T, U> unless(Predicate<? super U> condition) {
        return this.onlyIf(condition.negate());
    }

    public static <T extends Event, U extends T, V extends U, W extends U> EventPattern<T, U> anyOf(final EventPattern<T, V> p1, final EventPattern<T, W> p2) {
        return new EventPattern<T, U>(){

            @Override
            public Optional<? extends U> match(T event) {
                Optional match1 = p1.match(event);
                if (match1.isPresent()) {
                    return match1;
                }
                return p2.match(event);
            }

            @Override
            public Set<EventType<? extends U>> getEventTypes() {
                HashSet ret = new HashSet(p1.getEventTypes());
                ret.addAll(p2.getEventTypes());
                return ret;
            }
        };
    }

    public static <T extends Event> EventPattern<Event, T> eventType(final EventType<? extends T> eventType) {
        return new EventPattern<Event, T>(){

            @Override
            public Optional<T> match(Event event) {
                EventType actualType = event.getEventType();
                do {
                    if (!actualType.equals(eventType)) continue;
                    Event res = event;
                    return Optional.of(res);
                } while ((actualType = actualType.getSuperType()) != null);
                return Optional.empty();
            }

            @Override
            public Set<EventType<? extends T>> getEventTypes() {
                return Collections.singleton(eventType);
            }
        };
    }

    public static EventPattern<Event, KeyEvent> keyPressed() {
        return EventPattern.eventType(KeyEvent.KEY_PRESSED);
    }

    public static EventPattern<Event, KeyEvent> keyPressed(KeyCombination combination) {
        return EventPattern.keyPressed().onlyIf(arg_0 -> ((KeyCombination)combination).match(arg_0));
    }

    public static EventPattern<Event, KeyEvent> keyPressed(KeyCode code, KeyCombination.Modifier ... modifiers) {
        return EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(code, modifiers));
    }

    public static EventPattern<Event, KeyEvent> keyPressed(Predicate<KeyCode> keyTest, KeyCombination.Modifier ... modifiers) {
        return EventPattern.keyPressed(new KeyCodePatternCombination(keyTest, modifiers));
    }

    public static EventPattern<Event, KeyEvent> keyPressed(String character, KeyCombination.Modifier ... modifiers) {
        return EventPattern.keyPressed((KeyCombination)new KeyCharacterCombination(character, modifiers));
    }

    public static EventPattern<Event, KeyEvent> keyReleased() {
        return EventPattern.eventType(KeyEvent.KEY_RELEASED);
    }

    public static EventPattern<Event, KeyEvent> keyReleased(KeyCombination combination) {
        return EventPattern.keyReleased().onlyIf(arg_0 -> ((KeyCombination)combination).match(arg_0));
    }

    public static EventPattern<Event, KeyEvent> keyReleased(KeyCode code, KeyCombination.Modifier ... modifiers) {
        return EventPattern.keyReleased((KeyCombination)new KeyCodeCombination(code, modifiers));
    }

    public static EventPattern<Event, KeyEvent> keyReleased(Predicate<KeyCode> keyTest, KeyCombination.Modifier ... modifiers) {
        return EventPattern.keyReleased(new KeyCodePatternCombination(keyTest, modifiers));
    }

    public static EventPattern<Event, KeyEvent> keyReleased(String character, KeyCombination.Modifier ... modifiers) {
        return EventPattern.keyReleased((KeyCombination)new KeyCharacterCombination(character, modifiers));
    }

    public static EventPattern<Event, KeyEvent> keyTyped() {
        return EventPattern.eventType(KeyEvent.KEY_TYPED);
    }

    public static EventPattern<Event, KeyEvent> keyTyped(Predicate<String> charTest, KeyCombination.Modifier ... modifiers) {
        KeyTypedCombination combination = new KeyTypedCombination(charTest, modifiers);
        return EventPattern.keyTyped().onlyIf(combination::match);
    }

    public static EventPattern<Event, KeyEvent> keyTyped(String character, KeyCombination.Modifier ... modifiers) {
        return EventPattern.keyTyped(character::equals, modifiers);
    }

    public static EventPattern<Event, MouseEvent> mouseClicked() {
        return EventPattern.eventType(MouseEvent.MOUSE_CLICKED);
    }

    public static EventPattern<Event, MouseEvent> mouseClicked(MouseButton button) {
        return EventPattern.mouseClicked().onlyIf(e -> e.getButton() == button);
    }

    public static EventPattern<Event, MouseEvent> mousePressed() {
        return EventPattern.eventType(MouseEvent.MOUSE_PRESSED);
    }

    public static EventPattern<Event, MouseEvent> mousePressed(MouseButton button) {
        return EventPattern.mousePressed().onlyIf(e -> e.getButton() == button);
    }

    public static EventPattern<Event, MouseEvent> mouseReleased() {
        return EventPattern.eventType(MouseEvent.MOUSE_RELEASED);
    }

    public static EventPattern<Event, MouseEvent> mouseReleased(MouseButton button) {
        return EventPattern.mouseReleased().onlyIf(e -> e.getButton() == button);
    }

    public static EventPattern<Event, MouseEvent> mouseMoved() {
        return EventPattern.eventType(MouseEvent.MOUSE_MOVED);
    }
}

