/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event.experimental;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.collections.MapChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import org.fxmisc.wellbehaved.event.experimental.InputHandler;
import org.fxmisc.wellbehaved.event.experimental.InputMap;

public class Nodes {
    private static final String P_INPUTMAP = "org.fxmisc.wellbehaved.event.inputmap";
    private static final String P_HANDLERS = "org.fxmisc.wellbehaved.event.handlers";

    public static void addInputMap(Node node, InputMap<?> im) {
        Nodes.init(node);
        Nodes.setInputMap(node, InputMap.sequence(im, Nodes.getInputMap(node)));
    }

    public static void addFallbackInputMap(Node node, InputMap<?> im) {
        Nodes.init(node);
        Nodes.setInputMap(node, InputMap.sequence(Nodes.getInputMap(node), im));
    }

    public static void removeInputMap(Node node, InputMap<?> im) {
        Nodes.setInputMap(node, Nodes.getInputMap(node).without(im));
    }

    static InputMap<?> getInputMap(Node node) {
        Nodes.init(node);
        return (InputMap)node.getProperties().get((Object)P_INPUTMAP);
    }

    private static void setInputMap(Node node, InputMap<?> im) {
        node.getProperties().put((Object)P_INPUTMAP, im);
    }

    private static void init(final Node node) {
        if (node.getProperties().get((Object)P_INPUTMAP) == null) {
            node.getProperties().put((Object)P_INPUTMAP, InputMap.empty());
            node.getProperties().put((Object)P_HANDLERS, new ArrayList());
            MapChangeListener listener = ch -> {
                if (!P_INPUTMAP.equals(ch.getKey())) {
                    return;
                }
                Nodes.getHandlers(node).forEach(entry -> node.removeEventHandler((EventType)entry.getKey(), (EventHandler)entry.getValue()));
                Nodes.getHandlers(node).clear();
                InputMap inputMap = (InputMap)ch.getValueAdded();
                inputMap.forEachEventType(new InputMap.HandlerConsumer<Event>(){

                    @Override
                    public <E extends Event> void accept(EventType<? extends E> t, InputHandler<? super E> h) {
                        node.addEventHandler(t, h);
                        Nodes.getHandlers(node).add(new AbstractMap.SimpleEntry<EventType<? extends E>, InputHandler<? super E>>(t, h));
                    }
                });
            };
            node.getProperties().addListener(listener);
        }
    }

    private static List<Map.Entry<EventType<?>, EventHandler<?>>> getHandlers(Node node) {
        return (List)node.getProperties().get((Object)P_HANDLERS);
    }
}

