/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event.experimental.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javafx.event.Event;
import javafx.event.EventType;
import org.fxmisc.wellbehaved.event.experimental.InputHandler;
import org.fxmisc.wellbehaved.event.experimental.internal.PrefixTree;
import org.fxmisc.wellbehaved.event.experimental.template.InputHandlerTemplate;
import org.fxmisc.wellbehaved.event.experimental.template.InputMapTemplate;

class InputHandlerTemplateMap<S, E extends Event> {
    private PrefixTree<EventType<? extends E>, InputHandlerTemplate<S, ? super E>> handlerTree;

    private static <S, E extends Event> InputHandlerTemplate<S, E> sequence(InputHandlerTemplate<S, ? super E> h1, InputHandlerTemplate<S, ? super E> h2) {
        return (s, evt) -> {
            switch (h1.process(s, evt)) {
                case PROCEED: {
                    return h2.process(s, evt);
                }
                case CONSUME: {
                    return InputHandler.Result.CONSUME;
                }
                case IGNORE: {
                    return InputHandler.Result.IGNORE;
                }
            }
            throw new AssertionError((Object)"unreachable code");
        };
    }

    private static <S, E extends Event> PrefixTree.Ops<EventType<? extends E>, InputHandlerTemplate<S, ? super E>> ops() {
        return new PrefixTree.Ops<EventType<? extends E>, InputHandlerTemplate<S, ? super E>>(){

            @Override
            public boolean isPrefixOf(EventType<? extends E> t1, EventType<? extends E> t2) {
                for (EventType t = t2; t != null; t = t.getSuperType()) {
                    if (!t.equals(t1)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public EventType<? extends E> commonPrefix(EventType<? extends E> t1, EventType<? extends E> t2) {
                Iterator i1 = InputHandlerTemplateMap.toList(t1).iterator();
                Iterator i2 = InputHandlerTemplateMap.toList(t2).iterator();
                EventType common = null;
                while (i1.hasNext() && i2.hasNext()) {
                    EventType c2;
                    EventType c1 = (EventType)i1.next();
                    if (!Objects.equals(c1, c2 = (EventType)i2.next())) continue;
                    common = c1;
                }
                return common;
            }

            @Override
            public InputHandlerTemplate<S, ? super E> promote(InputHandlerTemplate<S, ? super E> h, EventType<? extends E> subTpe, EventType<? extends E> supTpe) {
                if (Objects.equals(subTpe, supTpe)) {
                    return h;
                }
                return (s, evt) -> {
                    if (this.isPrefixOf(subTpe, evt.getEventType())) {
                        return h.process(s, evt);
                    }
                    return InputHandler.Result.PROCEED;
                };
            }

            @Override
            public InputHandlerTemplate<S, E> squash(InputHandlerTemplate<S, ? super E> v1, InputHandlerTemplate<S, ? super E> v2) {
                return InputHandlerTemplateMap.sequence(v1, v2);
            }
        };
    }

    private static final List<EventType<?>> toList(EventType<?> t) {
        ArrayList l = new ArrayList();
        while (t != null) {
            l.add(t);
            t = t.getSuperType();
        }
        Collections.reverse(l);
        return l;
    }

    public InputHandlerTemplateMap() {
        this(PrefixTree.empty(InputHandlerTemplateMap.ops()));
    }

    private InputHandlerTemplateMap(PrefixTree<EventType<? extends E>, InputHandlerTemplate<S, ? super E>> handlerTree) {
        this.handlerTree = handlerTree;
    }

    public <F extends E> void insertAfter(EventType<? extends F> t, InputHandlerTemplate<S, ? super F> h) {
        InputHandlerTemplate<S, ? super F> handler = h;
        this.handlerTree = this.handlerTree.insert(t, handler, (h1, h2) -> InputHandlerTemplateMap.sequence(h1, h2));
    }

    public <T> InputHandlerTemplateMap<T, E> map(Function<? super InputHandlerTemplate<S, ? super E>, ? extends InputHandlerTemplate<T, E>> f) {
        return new InputHandlerTemplateMap<S, E>(this.handlerTree.map(f, InputHandlerTemplateMap.ops()));
    }

    void forEach(InputMapTemplate.HandlerTemplateConsumer<S, ? super E> f) {
        this.handlerTree.entries().forEach((? super T th) -> f.accept((EventType)th.getKey(), (InputHandlerTemplate)th.getValue()));
    }
}

