/*
 * Decompiled with CFR 0.152.
 */
package org.gamio.util;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerFactory;
import org.gamio.util.GmUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GmLogger
extends Logger {
    protected GmLogger(String name) {
        super(name);
    }

    public static GmLogger getLogger(Class<?> clazz) {
        return GmLogger.getLogger(clazz.getName());
    }

    public static GmLogger getLogger(String name) {
        return (GmLogger)Logger.getLogger((String)name, (LoggerFactory)GmLoggerFactory.getInstance());
    }

    public void debug(Object arg0, Object ... args) {
        if (this.isEnabledFor((Priority)Level.DEBUG)) {
            this.debug(GmUtil.buildString(arg0, args));
        }
    }

    public void error(Object arg0, Object ... args) {
        if (this.isEnabledFor((Priority)Level.ERROR)) {
            this.error(GmUtil.buildString(arg0, args));
        }
    }

    public void fatal(Object arg0, Object ... args) {
        if (this.isEnabledFor((Priority)Level.FATAL)) {
            this.fatal(GmUtil.buildString(arg0, args));
        }
    }

    public void info(Object arg0, Object ... args) {
        if (this.isEnabledFor((Priority)Level.INFO)) {
            this.info(GmUtil.buildString(arg0, args));
        }
    }

    public void warn(Object arg0, Object ... args) {
        if (this.isEnabledFor((Priority)Level.WARN)) {
            this.warn(GmUtil.buildString(arg0, args));
        }
    }

    public void debug(Throwable t, Object arg0, Object ... args) {
        if (this.isEnabledFor((Priority)Level.DEBUG)) {
            this.debug(GmUtil.buildString(arg0, args), t);
        }
    }

    public void error(Throwable t, Object arg0, Object ... args) {
        if (this.isEnabledFor((Priority)Level.ERROR)) {
            this.error(GmUtil.buildString(arg0, args), t);
        }
    }

    public void fatal(Throwable t, Object arg0, Object ... args) {
        if (this.isEnabledFor((Priority)Level.FATAL)) {
            this.fatal(GmUtil.buildString(arg0, args), t);
        }
    }

    public void info(Throwable t, Object arg0, Object ... args) {
        if (this.isEnabledFor((Priority)Level.INFO)) {
            this.info(GmUtil.buildString(arg0, args), t);
        }
    }

    public void warn(Throwable t, Object arg0, Object ... args) {
        if (this.isEnabledFor((Priority)Level.WARN)) {
            this.warn(GmUtil.buildString(arg0, args), t);
        }
    }

    private static final class GmLoggerFactory
    implements LoggerFactory {
        private static GmLoggerFactory cmLoggerFactory = new GmLoggerFactory();

        private GmLoggerFactory() {
        }

        public static GmLoggerFactory getInstance() {
            return cmLoggerFactory;
        }

        public Logger makeNewLoggerInstance(String name) {
            return new GmLogger(name);
        }
    }
}

