/*
 * Decompiled with CFR 0.152.
 */
package org.gamio.util;

import org.gamio.util.GmThread;

public abstract class GmUtil {
    private static final int BYTES_IN_ROW = 16;
    private static final String fileSeparator = System.getProperty("file.separator");
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final byte[] bhDigits = new byte[256];
    private static final byte[] blDigits = new byte[256];

    public static String getFileSeparator() {
        return fileSeparator;
    }

    public static String getLineSeparator() {
        return lineSeparator;
    }

    public static char bhToChar(int b) {
        return (char)bhDigits[b & 0xFF];
    }

    public static char blToChar(int b) {
        return (char)blDigits[b & 0xFF];
    }

    public static StringBuilder getStringBuilder() {
        try {
            return ((GmThread)Thread.currentThread()).getStringBuilder();
        }
        catch (ClassCastException e) {
            return new StringBuilder();
        }
    }

    public static StringBuilder getStringBuilder(int capacity) {
        try {
            return ((GmThread)Thread.currentThread()).getStringBuilder(capacity);
        }
        catch (ClassCastException e) {
            return new StringBuilder(capacity);
        }
    }

    public static String buildString(Object arg, Object ... args) {
        if (args.length < 1) {
            return arg.toString();
        }
        StringBuilder strBldr = GmUtil.getStringBuilder().append(arg);
        for (Object o : args) {
            strBldr.append(o);
        }
        return strBldr.toString();
    }

    public static void dumpByte(StringBuilder strBldr, int b) {
        strBldr.append((char)bhDigits[b &= 0xFF]);
        strBldr.append((char)blDigits[b]);
    }

    public static void dumpInt32(StringBuilder strBldr, int i) {
        GmUtil.dumpByte(strBldr, i >>> 24);
        GmUtil.dumpByte(strBldr, i >>> 16);
        GmUtil.dumpByte(strBldr, i >>> 8);
        GmUtil.dumpByte(strBldr, i);
    }

    public static void dump(StringBuilder strBldr, byte[] b) {
        GmUtil.dump(strBldr, b, 0, b.length);
    }

    public static void dump(StringBuilder strBldr, byte[] b, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int addr = 0;
        length -= offset;
        while (length > 0) {
            int i;
            GmUtil.dumpInt32(strBldr, addr);
            strBldr.append("h:");
            for (i = 0; i < 16 && length > 0; ++i, --length) {
                strBldr.append(' ');
                GmUtil.dumpByte(strBldr, b[offset + i]);
            }
            int len = i;
            while (i++ < 16) {
                strBldr.append("   ");
            }
            strBldr.append("      ");
            for (i = 0; i < len; ++i) {
                char c;
                strBldr.append(Character.isISOControl(c = (char)(b[offset++] & 0xFF)) ? (char)'.' : (char)c);
            }
            strBldr.append(GmUtil.getLineSeparator());
            addr += 16;
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int hex;
            GmUtil.bhDigits[i] = (byte)(hex += (hex = i >>> 4) < 10 ? 48 : 55);
            hex = i & 0xF;
            GmUtil.blDigits[i] = (byte)(hex += hex < 10 ? 48 : 55);
        }
    }
}

