/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.impl.PreBootstrapLogger;
import org.apache.juli.logging.impl.SeparateLogbackSupport;
import org.slf4j.Logger;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JDelegatingLog
implements Log,
Serializable {
    private static final long serialVersionUID = 4326548378678492807L;
    private static final String FQCN = SLF4JDelegatingLog.class.getName();
    private static final String DIAGNOSTICS_LEVEL_PROPERTY = "org.apache.juli.logging.impl.SLF4JDelegatingLog.diagnostics";
    public static volatile int diagnostics = Integer.getInteger("org.apache.juli.logging.impl.SLF4JDelegatingLog.diagnostics", 30);
    protected String name;
    private volatile transient Logger log;
    private boolean noLocationAware;

    public SLF4JDelegatingLog() {
    }

    public SLF4JDelegatingLog(String name) {
        if (SeparateLogbackSupport.bootstrapped) {
            this.setLogger(SeparateLogbackSupport.obtainLogger(name));
        } else {
            this.setLogger(SeparateLogbackSupport.obtainPreBootstrapLoggerIfNecessary(this, name));
        }
    }

    void setLogger(Logger logger) {
        this.log = logger;
        this.noLocationAware = !(logger instanceof LocationAwareLogger) && !(logger instanceof PreBootstrapLogger);
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.log.isErrorEnabled();
    }

    public void trace(Object msg) {
        this.trace(msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void trace(Object msg, Throwable thrown) {
        if (SeparateLogbackSupport.bootstrapped) {
            this.doTrace(msg, thrown);
            return;
        }
        SeparateLogbackSupport.bootstrapLoggingSystemIfPossible();
        Class<SLF4JDelegatingLog> clazz = SLF4JDelegatingLog.class;
        synchronized (SLF4JDelegatingLog.class) {
            this.doTrace(msg, thrown);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void doTrace(Object msg, Throwable thrown) {
        if (this.noLocationAware) {
            this.log.trace(String.valueOf(msg), thrown);
        } else {
            ((LocationAwareLogger)this.log).log(null, FQCN, 0, String.valueOf(msg), null, thrown);
        }
    }

    public void debug(Object msg) {
        this.debug(msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void debug(Object msg, Throwable thrown) {
        if (SeparateLogbackSupport.bootstrapped) {
            this.doDebug(msg, thrown);
            return;
        }
        SeparateLogbackSupport.bootstrapLoggingSystemIfPossible();
        Class<SLF4JDelegatingLog> clazz = SLF4JDelegatingLog.class;
        synchronized (SLF4JDelegatingLog.class) {
            this.doDebug(msg, thrown);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void doDebug(Object msg, Throwable thrown) {
        if (this.noLocationAware) {
            this.log.debug(String.valueOf(msg), thrown);
        } else {
            ((LocationAwareLogger)this.log).log(null, FQCN, 10, String.valueOf(msg), null, thrown);
        }
    }

    public void info(Object msg) {
        this.info(msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void info(Object msg, Throwable thrown) {
        if (SeparateLogbackSupport.bootstrapped) {
            this.doInfo(msg, thrown);
            return;
        }
        SeparateLogbackSupport.bootstrapLoggingSystemIfPossible();
        Class<SLF4JDelegatingLog> clazz = SLF4JDelegatingLog.class;
        synchronized (SLF4JDelegatingLog.class) {
            this.doInfo(msg, thrown);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void doInfo(Object msg, Throwable thrown) {
        if (this.noLocationAware) {
            this.log.info(String.valueOf(msg), thrown);
        } else {
            ((LocationAwareLogger)this.log).log(null, FQCN, 20, String.valueOf(msg), null, thrown);
        }
    }

    public void warn(Object msg) {
        this.warn(msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void warn(Object msg, Throwable thrown) {
        if (SeparateLogbackSupport.bootstrapped) {
            this.doWarn(msg, thrown);
            return;
        }
        SeparateLogbackSupport.bootstrapLoggingSystemIfPossible();
        Class<SLF4JDelegatingLog> clazz = SLF4JDelegatingLog.class;
        synchronized (SLF4JDelegatingLog.class) {
            this.doWarn(msg, thrown);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void doWarn(Object msg, Throwable thrown) {
        if (this.noLocationAware) {
            this.log.warn(String.valueOf(msg), thrown);
        } else {
            ((LocationAwareLogger)this.log).log(null, FQCN, 30, String.valueOf(msg), null, thrown);
        }
    }

    public void error(Object msg) {
        this.error(msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void error(Object msg, Throwable thrown) {
        if (SeparateLogbackSupport.bootstrapped) {
            this.doError(msg, thrown);
            return;
        }
        SeparateLogbackSupport.bootstrapLoggingSystemIfPossible();
        Class<SLF4JDelegatingLog> clazz = SLF4JDelegatingLog.class;
        synchronized (SLF4JDelegatingLog.class) {
            this.doError(msg, thrown);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void doError(Object msg, Throwable thrown) {
        if (this.noLocationAware) {
            this.log.error(String.valueOf(msg), thrown);
        } else {
            ((LocationAwareLogger)this.log).log(null, FQCN, 40, String.valueOf(msg), null, thrown);
        }
    }

    public void fatal(Object msg) {
        this.error(msg, null);
    }

    public void fatal(Object msg, Throwable thrown) {
        this.error(msg, thrown);
    }

    protected Object readResolve() throws ObjectStreamException {
        return new SLF4JDelegatingLog(this.name);
    }
}

