/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.impl;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.juli.logging.impl.PreBootstrapLogger;
import org.apache.juli.logging.impl.PreBootstrapLoggingEvent;
import org.apache.juli.logging.impl.SLF4JDelegatingLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.Util;

public class SeparateLogbackSupport {
    private static final String SLF4J_IMPL_STATIC_LOGGER_BINDER_RSC = "org/slf4j/impl/StaticLoggerBinder.class";
    static final String LOGBACK_STATUS_LISTENER_PROPERTY = "logback.statusListenerClass";
    static final String LOGBACK_CONFIG_PROPERTY = "logback.configurationFile";
    static final String LOGBACK_CTX_SELECTOR_PROPERTY = "logback.ContextSelector";
    private static final String JULI_PREXIX = "juli.";
    static final String JULI_LOGBACK_STATUS_LISTENER_PROPERTY = "juli.logback.statusListenerClass";
    static final String JULI_LOGBACK_CONFIG_PROPERTY = "juli.logback.configurationFile";
    static final String JULI_LOGBACK_CTX_SELECTOR_PROPERTY = "juli.logback.ContextSelector";
    static volatile boolean bootstrapped = false;
    private static boolean doBootstrapASAP;
    private static final AtomicInteger count;
    static final int ONCE_EVERY_FIVE_TIMES = 5;

    static Logger obtainLogger(String name) {
        if (SLF4JDelegatingLog.diagnostics <= 0) {
            Util.report((String)("SeparateLogbackSupport.obtainLogger('" + name + "')"));
        }
        return LoggerFactory.getLogger(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Logger obtainPreBootstrapLoggerIfNecessary(SLF4JDelegatingLog facade, final String name) {
        if (doBootstrapASAP) {
            final Logger[] loggerRef = new Logger[]{null};
            SeparateLogbackSupport.doBootstrapRunning(new Runnable(){

                @Override
                public void run() {
                    loggerRef[0] = SeparateLogbackSupport.obtainLogger(name);
                }
            });
            return loggerRef[0];
        }
        SeparateLogbackSupport.bootstrapLoggingSystemIfPossible();
        Class<SLF4JDelegatingLog> clazz = SLF4JDelegatingLog.class;
        synchronized (SLF4JDelegatingLog.class) {
            if (bootstrapped) {
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return SeparateLogbackSupport.obtainLogger(name);
            }
            if (SLF4JDelegatingLog.diagnostics <= 0) {
                Util.report((String)("SLF4JDelegatingLog > new PreBootstrapLogger('" + name + "')"));
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return new PreBootstrapLogger(facade, name);
        }
    }

    static void bootstrapLoggingSystemIfPossible() {
        ClassLoader catalinaLoader;
        ClassLoader systemLoader;
        if (count.incrementAndGet() % 5 != 0) {
            return;
        }
        if (SLF4JDelegatingLog.diagnostics <= 10) {
            Util.report((String)"SeparateLogbackSupport.doBootstrapIfPossible()");
        }
        if ((systemLoader = SeparateLogbackSupport.class.getClassLoader()) != (catalinaLoader = Thread.currentThread().getContextClassLoader()) && catalinaLoader != null && catalinaLoader instanceof URLClassLoader) {
            if (SLF4JDelegatingLog.diagnostics <= 10) {
                URL systemRsc = systemLoader.getResource(SLF4J_IMPL_STATIC_LOGGER_BINDER_RSC);
                URL catalinaRsc = catalinaLoader.getResource(SLF4J_IMPL_STATIC_LOGGER_BINDER_RSC);
                Util.report((String)("in system loader [" + systemLoader + "]: " + systemRsc));
                Util.report((String)("in common loader [" + catalinaLoader + "]: " + catalinaRsc));
            }
            SeparateLogbackSupport.doBootstrapRunning(new DeferredInit(catalinaLoader));
        }
    }

    private static void runBootstrapAtShutdownIfNotYetDone() {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (SLF4JDelegatingLog.diagnostics <= 10) {
                        Util.report((String)"SeparateLogbackSupport.ShutdownHook.run()");
                    }
                    ClassLoader catalinaLoader = 2.currentThread().getContextClassLoader();
                    SeparateLogbackSupport.doBootstrapRunning(new DeferredInit(catalinaLoader));
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doBootstrapRunning(Runnable actualInitCode) {
        Class<SLF4JDelegatingLog> clazz = SLF4JDelegatingLog.class;
        synchronized (SLF4JDelegatingLog.class) {
            if (bootstrapped) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            String juliStatusListener = System.getProperty(JULI_LOGBACK_STATUS_LISTENER_PROPERTY);
            String juliConfigFile = System.getProperty(JULI_LOGBACK_CONFIG_PROPERTY);
            String juliCtxSelector = System.getProperty(JULI_LOGBACK_CTX_SELECTOR_PROPERTY);
            String generalStatusListener = System.getProperty(LOGBACK_STATUS_LISTENER_PROPERTY);
            String generalConfigFile = System.getProperty(LOGBACK_CONFIG_PROPERTY);
            String generalCtxSelector = System.getProperty(LOGBACK_CTX_SELECTOR_PROPERTY);
            try {
                SeparateLogbackSupport.overrideSystemProperty(LOGBACK_STATUS_LISTENER_PROPERTY, juliStatusListener);
                SeparateLogbackSupport.overrideSystemProperty(LOGBACK_CONFIG_PROPERTY, juliConfigFile);
                SeparateLogbackSupport.overrideSystemProperty(LOGBACK_CTX_SELECTOR_PROPERTY, juliCtxSelector);
                actualInitCode.run();
                bootstrapped = true;
            }
            finally {
                SeparateLogbackSupport.restoreOverriddenSystemProperty(LOGBACK_STATUS_LISTENER_PROPERTY, juliStatusListener, generalStatusListener);
                SeparateLogbackSupport.restoreOverriddenSystemProperty(LOGBACK_CONFIG_PROPERTY, juliConfigFile, generalConfigFile);
                SeparateLogbackSupport.restoreOverriddenSystemProperty(LOGBACK_CTX_SELECTOR_PROPERTY, juliCtxSelector, generalCtxSelector);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void overrideSystemProperty(String propName, String overridingValue) {
        if (overridingValue != null) {
            System.setProperty(propName, overridingValue);
        }
    }

    private static void restoreOverriddenSystemProperty(String propName, String overridingValue, String previousValue) {
        if (overridingValue != null) {
            if (previousValue == null) {
                System.getProperties().remove(propName);
            } else {
                System.setProperty(propName, previousValue);
            }
        }
    }

    static {
        ClassLoader systemLoader = SeparateLogbackSupport.class.getClassLoader();
        if (null != systemLoader && null != systemLoader.getResource(SLF4J_IMPL_STATIC_LOGGER_BINDER_RSC)) {
            if (SLF4JDelegatingLog.diagnostics <= 10) {
                Util.report((String)"SeparateLogbackSupport.<static init>(): detected SLF4J implementation on classpath. Using it ASAP.");
            }
            doBootstrapASAP = true;
        } else {
            doBootstrapASAP = false;
            SeparateLogbackSupport.runBootstrapAtShutdownIfNotYetDone();
        }
        count = new AtomicInteger(0);
    }

    private static class DeferredInit
    implements Runnable {
        private ClassLoader catalinaLoader;

        public DeferredInit(ClassLoader catalinaLoader) {
            this.catalinaLoader = catalinaLoader;
        }

        @Override
        public void run() {
            PreBootstrapLoggingEvent.flushEvents(this.catalinaLoader);
            PreBootstrapLogger.swapLoggers();
        }
    }
}

