/*
 * Copyright (c) 2016. Samsung Electronics Co., LTD
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.samsung.mpl.gearwearlibrary.models.events;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Occurs when user stops touching the screen (or rotary event occurs)
 */
public class TouchEnd implements Parcelable {

    public static final Creator<TouchEnd> CREATOR = new Creator<TouchEnd>() {
        @Override
        public TouchEnd createFromParcel(Parcel in) {
            return new TouchEnd();
        }

        @Override
        public TouchEnd[] newArray(int size) {
            return new TouchEnd[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
    }

    @Override
    public String toString() {
        return TouchEnd.class.getSimpleName();
    }
}
