/* Copyright 2016 Samsung Electronics Co., LTD
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gearvrf.physics;

import org.gearvrf.GVRSceneObject;
import org.gearvrf.IEvents;

/**
 * This interface defines events generated by the collision of {@link GVRRigidBody}.
 *
 */
public interface ICollisionEvents extends IEvents {

    /**
     * Called when a Collision starts to be processed on a scene object.
     *
     * @param sceneObj0 {@link GVRSceneObject} with a {@link GVRRigidBody} in collision with sceneObj1
     * @param sceneObj1 {@link GVRSceneObject} with a {@link GVRRigidBody} in collision with sceneObj0
     * @param normal a float vector with the normal between the two colliding objects
     * @param distance distance between the objects (usually zero)
     */
    void onEnter(GVRSceneObject sceneObj0, GVRSceneObject sceneObj1, float normal[], float distance);

    /**
     * Called when a Collision sceases to happen on a scene object.
     *
     * @param sceneObj0 {@link GVRSceneObject} with a {@link GVRRigidBody} in collision with sceneObj1
     * @param sceneObj1 {@link GVRSceneObject} with a {@link GVRRigidBody} in collision with sceneObj0
     * @param normal a float vector with the normal between the two colliding objects
     * @param distance distance between the objects (usually zero)
     */
    void onExit(GVRSceneObject sceneObj0, GVRSceneObject sceneObj1, float normal[], float distance);
}
