/*
 * Decompiled with CFR 0.152.
 */
package geb.error;

import geb.AtVerificationResult;
import geb.Page;
import geb.error.GebException;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnexpectedPageException
extends GebException {
    public UnexpectedPageException(Page page) {
        this(page, null);
    }

    public UnexpectedPageException(Class<? extends Page> page) {
        super((Object)String.format("At checker page verification failed for page %s", page.getName()));
    }

    public UnexpectedPageException(Page page, Throwable cause) {
        super((Object)String.format("At checker page verification failed for page %s", page), cause);
    }

    public UnexpectedPageException(Class<? extends Page> actualPage, Class<? extends Page> expectedPage) {
        super((Object)String.format("An unexpected page %s was encountered when expected to be at %s", actualPage.getName(), expectedPage.getName()));
    }

    public UnexpectedPageException(Class<? extends Page> actualPage, Page expectedPage) {
        super((Object)String.format("An unexpected page %s was encountered when expected to be at %s", actualPage.getName(), expectedPage.getClass().getName()));
    }

    public UnexpectedPageException(Class<? extends Page> actualPage, Class<? extends Page>[] potentials) {
        super((Object)String.format("An unexpected page %s was encountered when trying to find page match (given potentials: %s)", actualPage.getName(), DefaultGroovyMethods.toString((Object[])potentials)));
    }

    public UnexpectedPageException(Class<? extends Page> actualPage, Page[] potentials) {
        super((Object)String.format("An unexpected page %s was encountered when trying to find page match (given potentials: %s)", actualPage.getName(), DefaultGroovyMethods.toString((Object[])potentials)));
    }

    public UnexpectedPageException(Map<? extends Page, AtVerificationResult> pageVerificationResults) {
        super((Object)String.format("Unable to find page match. At checker verification results:%n%n%s", UnexpectedPageException.format(pageVerificationResults)));
    }

    private static String format(Map<? extends Page, AtVerificationResult> pageVerificationResults) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<? extends Page, AtVerificationResult> atVerificationResultEntry : pageVerificationResults.entrySet()) {
            builder.append(String.format("Result for %s: %s%n%n", atVerificationResultEntry.getKey().getClass().getName(), atVerificationResultEntry.getValue()));
        }
        return builder.toString();
    }
}

